fi = open("gordy.tmx", "r")
reading = False
tiles = []
for li in fi.readlines():
  if "<layer" in li:
    reading = True
    continue
  if not reading:
    continue
  if "csv" in li:
    continue
  if "/data" in li:
    reading = False
    continue
  d = [int(n) for n in li.rstrip().split(",") if n!=""]
  tiles.extend(d)
fi.close()

def preproc():
  for y in range(224):
    for x in range(256):
      t = y*256 + x
      if tiles[t]==0 or tiles[t]==21 or tiles[t]>64: continue
      b = t+256
      size = 1
      while b < len(tiles) and tiles[t]==tiles[b] and tiles[b-1]!=tiles[b]:
        size += 1
        b+=256
      if size > 3:
#        print (x, y, size, tiles[t])
        tiles[t]+=64
#        print(tiles[t])
        for n in range(t+256, b-256, 256):
          tiles[n] = tiles[n-1]

preproc()

tile_count = {}

last_t = None
for t in tiles:
  if t==last_t: continue
  last_t = t
  if t in tile_count:
    tile_count[t]+=1
  else:
    tile_count[t]=1
    
tilepref = sorted(list(tile_count.keys()), key=lambda a: tile_count[a], reverse=True)
#print(tilepref)

tilelookup = {}

for i in range(len(tilepref)):
  tilelookup[tilepref[i]] = i
  
#print(tilelookup)

#print(len(tile_count))

tile_order = []
for x in range(16):
  for y in range(16):
    for i in range(16):
      for j in range(14):
        tile_order.append(x*16+i + (y*14+j)*256)
        
tile_order = []
for x in range(57344):
  tile_order.append(x)

ob = 0
op = 0

def writebit(b):
  global op
  global ob
  op += 1
  ob >>= 1
  if b>0: ob |= 128
#  print(op, b)
  if op==8:
#    print(ob)
    out.append(ob)
#    print(ob)
    ob = 0
    op = 0
    
def finishbits():
  global op
  global ob
  while op < 8:
    op += 1
    ob >>= 1
  out.append(ob)
  ob = 0
  op = 0
  
def writebits(val, bits):
#  print(val, bits)
  for i in range(bits-1, -1, -1):
    writebit(val>>i&1)

def writeint(val):
  bits = 0
  while True:
    bits += 1
    mx = (1<<bits)-1
    vv = min(val, mx)
    writebits(vv, bits)
    val -= vv
    if vv < mx:
      break

def writepair(tile, count):
  writeint(tile)
  writeint(count)

out = []

def compress(fro, to):
    tile = -1
    count = 1
    
    found_leaf = False

    tt = 0
    for i in tile_order[fro:to]:
      t = tiles[i]
      if t==13: found_leaf = True
      if t == tile:
        count+=1
      if t != tile:
        if tile!=-1:
          writepair(tilelookup[tile], count)
          tt += count
        tile = t
        count = 1
    
    writepair(tilelookup[tile], count)
    tt += count
    finishbits()
    
#    print(fro, found_leaf)
    return found_leaf

if __name__=="__main__":
    tilepref.reverse()
    for t in tilepref:
      out.append(t)
      
    compress(0, 57344)
    print("%2.1f%%"%(len(out)/8192*100))
    print(len(out), (len(out)-8192))

    while len(out)<8192:
      out.append(0)
      
    mapout = []

    s = ""
    for o in out:
      s += "%02x"%(o)

    while(len(s) > 0):
      mapout.append(s[:256])
      s = s[256:]

    fi = open("..\gordy.p8", "r")
    gordymap = fi.readlines()
    fi.close()

    skipuntil = None
    fi = open("..\gordy.p8", "w")
    for li in gordymap:
      li = li.rstrip().replace("\t", "  ")
      if skipuntil!=None:
        if li.startswith(skipuntil):
          skipuntil = None
        else:
          continue
      fi.write(li+"\n")
      if li=="__map__":
        for li in mapout:
          fi.write(li+"\n")
        skipuntil = "__"
    fi.close()

