pico-8 cartridge // http://www.pico-8.com
version 41
__lua__
g_m={}
g_ents={}
g_rooms={}
g_message=""
g_message_t=8
g_seenmessage={}
g_savable={}
g_savepos=0
g_lrad=24
g_sincerest=0

function dict(s)
  local x=split(s)
  local r={}
  for i=1,#x,2 do r[tonum(x[i])]=x[i+1] end
  return r
end

function seen(pos,set)
  local r=room(pos)
  if r.y<112 then return false end
  local n=56+r.y/14-8
  local mask=1<<(r.x/16-1)
  if set then
    dset(n,dget(n)|mask)
  else return (dget(n)&mask)>0
  end
end

function roompool(pos)
  local r=room(pos)
  local id=r.y/14*16+r.x/16
  if not g_rooms[id] then
    g_rooms[id]={}
  end
  return g_rooms[id]
end

toinsert={}

function insertent(e) add(toinsert,e) end

function flushinsert()
  for e in all(toinsert) do
    addent(e,1)
  end
  toinsert={}
end

function addent(e,where)
  if not where then add(roompool(e.p),e)
  else add(roompool(e.p),e,where)
  end
  return e
end

function collide(p1,s1,p2,s2)
  if p1.x-s1.x>=p2.x+s2.x then return false end
  if p1.x+s1.x<=p2.x-s2.x then return false end
  if p1.y-s1.x>=p2.y+s2.y then return false end
  if p1.y+s1.y<=p2.y-s2.x then return false end
  return true
end

function solid(x,y) return fget(mapat(x,y))&247>0 end

function room(p)
  return v(flr(p.x/16)*16,flr(p.y/14)*14)
end

function blocked(p,size,cmask,o)
  local x,y
  for x=flr(p.x-size.x),ceil(p.x+size.x) do
    for y=flr(p.y-size.y),ceil(p.y+size.y) do
      local at=mapat(x,y)
      if fget(at)&cmask>0 and collide(p,size,v(x+.5,y+.5),v(.5,.5)) then
        if o then
          if at==49 and o.lollipop then
            ?"\ai6v5x1s0c2c4"
            mapset(x,y,73)
          end
          o.blocklist[at]=true
        end
        return true
      end
    end
  end
end

function mcollide()
  local p=v(px,py)
  if current!=player then
    local r1=room(vadd(p,current.size))
    local r2=room(vsub(p,current.size))
    if r1.x!=r2.x or r1.y!=r2.y then return true end
  end
  return blocked(p,current.size,current.cmask,current)
end

function entity(pos,size)
  return {
    p=v(pos),
    timer=0,
    cmask=7,
    vel=vzero(),
    size=vdiv(v(size or v(1,1)),2),
    op=v(pos),
    ov=vzero(),
    blocklist={},
    restart=function(_)
      _.p  =v(_.op)
      _.vel=v(_.ov)
    end,
    move=function(_,speed)
      current=_
      function roundaxis(c,f)
        if _==player and f==0 then
          cs=c%1
          if cs>.1 and cs<.375 then return flr(c)+.375
          elseif cs<.9 and cs>.625 then return flr(c)+.625
          end
        end
        return c
      end

      _.blocklist={}
      speed=speed or 1
      if _.onfire then speed*=1.2 end
      if g_underw then speed*=.75 end
      if _.atop==48 then speed*=1.2 end
      px=_.p.x
      py=_.p.y
      local dx=px+_.vel.x*speed
      function addclamp(p,d,n)
        ov=p
        p+=n
        if sgn(p-d)==sgn(n) then return d end
        return p
      end
      while px<dx do
        px=addclamp(px,dx,.125)
        if mcollide() then
          py=roundaxis(py,g_a.y)
          if mcollide() then
            px=ov
            py=_.p.y
            _.vel.x=0
            break
          end
        end
      end
      while px>dx do
        px=addclamp(px,dx,-.125)
        if mcollide() then
          py=roundaxis(py,g_a.y)
          if mcollide() then
            px=ov
            py=_.p.y
            _.vel.x=0
            break
          end
        end
      end
      nx=px
      local dy=py+_.vel.y*speed
      while py<dy do
        py=addclamp(py,dy,.125)
        if mcollide() then
          px=roundaxis(px,g_a.x)
          if mcollide() then
            px=nx
            py=ov
            _.vel.y=0
            break
          end
        end
      end
      while py>dy do
        py=addclamp(py,dy,-.125)
        if mcollide() then
          px=roundaxis(px,g_a.x)
          if mcollide() then
            px=nx
            py=ov
            _.vel.y=0
            break
          end
        end
      end
      _.p=v(px,py)
      _.atop=mapat(px,py)
    end
  }
end

function restartroom(r,big)
  for e in all(r) do
    if big then e.sticky=false end
    if not e.sticky then e.onfire=e.oldonfire end
    if e.restart then
      e:restart()
      if e.remove then del(g_ents,e) end
    end
  end
end

function changerooms()
  if g_web then g_web:vanish() end

  restartroom(g_ents)
  g_ents=roompool(player.p)

  seen(player.p,true)
  calcmap()

  local newpos=room(player.p)
  local diff=vzero()
  local skip=true
  if g_mpos!=nil then
    diff=vsub(newpos,g_mpos)
    local a=abs(diff.x)+abs(diff.y)
    if a==14 or a==16 then skip=false end
  end
  if abs(diff.y)==112 then
    local down=newpos.y>g_mpos.y
    for i=0,16 do
      _draw()
      local n=i
      if down then n=15-i end
      hudclip()
      rectfill(0,-128+n*16,128,n*16,0)
      ?"\^1"
      if i==7 then
        g_mpos=newpos
        if g_mpos.y>=112 then g_underw=false end
      end
    end
  elseif skip then g_mpos=newpos else
    diff=vmul(vnorm(diff),2)
    repeat
      g_mpos=vadd(g_mpos,diff)
      _draw()
      ?"\^1"
    until veq(g_mpos,newpos)
  end

  if player.p.y>112 then
    setchannels(7)
    poke(0x5f43,0)
  else
    setchannels(11)
    poke(0x5f43,15)
  end
end

function save(e)
  if loading then return end
  dset(g_savepos,flr(e.p.x)+flr(e.p.y)*16)
  g_savepos+=1
end

function registersave(e) g_savable[flr(e.p.x)+flr(e.p.y)*16]=e end

function message(m)
  if g_message!=m and g_new_message!=m then
    g_new_message=m
    g_message_t=-8
  end
end

function messageonce(m)
  if not g_seenmessage[m] then
    message(m)
    g_seenmessage[m]=true
  end
end

function _update()
  if g_finito then return end
  if g_menu then
    tickmenu()
    return
  end

  if player.candle and g_lrad<48 then g_lrad+=.5 end

  if g_celeb_t<=0 and not g_resting then
    for e in all(g_ents) do
      if e.tick and not e.remove then
        e.timer+=1
        e:tick()
      end
      if e.remove then del(g_ents,e) end
    end
    flushinsert()
  end

  player:tick()
  if not veq(g_mpos,room(player.p)) then changerooms() end

  if g_message_t<8 then
    g_message_t+=.5
    if g_message_t==0 then g_message=g_new_message end
  end
end

toothmap=dict("22,0,21,0,53,0,49,0,50,0")

function drawtile(x,y)
  local t=mapat(x,y)

  if t==49 and not player.sight then
    t=mapat(x,y+1)
    if toothmap[t] then t=0 end
  end
  if t==0 and g_underw and g_mpos.y<112 then t=71 end

  local dx=x*8
  local dy=y*8
  if fget(t,1) then
    local lx=flr(time()*6+y*3)%8
    local sx=40
    local sy=0
    if t==20 then
      sx=32
      sy=8
    end
    sspr(sx+lx,sy,8-lx,4,dx,dy)
    sspr(sx,sy,lx,4,dx+8-lx,dy)
    lx=8-lx
    sspr(sx+lx,sy,8-lx,4,dx,dy+4)
    sspr(sx,sy,lx,4,dx+8-lx,dy+4)
  elseif t!=0 then spr(t,dx,dy) end
  if rounded[t] then
    local d=v(-1, -1)
    for i=0,3 do
      if not rounded[mapat(x+d.x,y)] and
         not rounded[mapat(x,y+d.y)] and
         mapat(x+d.x,y+d.y)!=36 then
        pset(dx+(d.x+1)*3.5, dy+(d.y+1)*3.5, 0)
      end
      d = cw(d)
    end
  end
end


walkies=dict("0,,61,,45,,37,,22,")
bootwalkies=dict("0,,61,,45,,5,,20,,37,,22,")

function walkable(x,y)
  local f=mapat(x,y)
  if player.boots then return bootwalkies[f] end
  return walkies[f]
end

icons=dict("67,ship,68,cryo,66,ladder,65,spawner,74,dad")
items=split("60,map,13,candle,14,boots,55,sight,51,scuba,72,lollipop,59,atlas")

function calcmap()
  mp={}
  for x=0,15 do
    for y=1,8 do
      local rx=x*16
      local ry=(y+7)*14
      local s=seen(v(rx,ry))
      local key=y*16+x
      local mv={s}
      mp[key]=mv
      if s then
        local fx=x*8
        local fy=y*8+32
        for i=1,14 do
          if walkable(rx+i,ry) then mv.u=true end
          if walkable(rx+i,ry+13) then mv.d=true end
        end
        for i=1,12 do
          if walkable(rx,ry+i) then mv.l=true end
          if walkable(rx+15,ry+i) then mv.r=true end
        end
      end
      if s or player.atlas then
        local r=roompool(v(x*16,(y+7)*14))
        local found={}
        for e in all(r) do
          if e.name and not e.remove then found[e.name]=true end
        end
        for k,v in pairs(icons) do
          if found[v] then mv.i=tonum(k) end
        end
      end
    end
  end
end

function drawents()
  player:draw()

  for e in all(g_ents) do
    if e.draw and not e.remove then
      e:draw(e.p.x*8-4,e.p.y*8-4)
    end
  end

  if g_die_t==0 then player:draw() end
end

function hudclip()
  clip(0,8,128,112)
end

function _draw()
  cls()

  if g_menu then
    for i in all(g_dlist) do
      if type(i[3])=="number" then
        palt(0,false)
        spr(i[1],i[2],i[3],i[4],i[5])
        pal()
      else printd(i[3],i[1],i[2]) end
    end
    drawmenu()
    return
  end

  function camclip()
    camera(g_mpos.x*8,g_mpos.y*8-8)
    hudclip()
  end
  camclip()

  local pp=v(player.p)
  if pp.y >=112 and g_mpos.y<112 then pp.y-=112 end

  local darkr=g_lrad+sin(time()/5)*2+2
  local darkx=(pp.x-g_mpos.x)*8
  local darky=(pp.y-g_mpos.y+1)*8

  if g_mpos.y<112 then
    local ym=max(darky-darkr,8)
    clip(darkx-darkr,ym,darkr*2,min(darky+darkr,120)-ym)
  end

  for x=0,15 do
    for y=0,13 do
      drawtile(g_mpos.x+x,g_mpos.y+y)
    end
  end

  if not player.sight then
    drawents()
  end

  camera()
  if g_underw and g_mpos.y<112 then drawdust() end

  if g_mpos.y<112 then
    local r2=darkr*2
    local py=darky-darkr
    for px=darkx-darkr,darkx+darkr do
      local c=(px-(darkx-darkr))/(r2)*2-1
      local ph=(1-sqrt(1-c*c))*darkr+.01
      line(px,py,px,py+ph,0)
      line(px,py+r2-ph,px,py+r2,0)
    end
  end

  if player.sight then
    camclip()
    drawents()
    camera()
  end

  clip()

  if player.map and butn(5) and g_sincerest>10 then
    fillp(▒)
    rectfill(0,0,128,128,0)
    fillp()

    local x=12
    for i=1,14,2 do
      if player[items[i+1]] then spr(items[i],x,16) end
      x+=16
    end

    if player.p.y<114 then
      message("the map only works aboveground.")
      return
    end

    for x=0,15 do
      for y=1,8 do
        local fx=x*8
        local fy=y*8+32
        local key=y*16+x
        local mv=mp[key]
        if mv[1] then rectfill(fx,fy,fx+6,fy+6,12) end
        if mv.i then spr(mv.i,x*8-1,y*8+32) end
        if mv.u then rectfill(fx+2,fy-1,fx+4,fy-1) end
        if mv.d then rectfill(fx+2,fy+7,fx+4,fy+7) end
        if mv.l then rectfill(fx-1,fy+2,fx-1,fy+4) end
        if mv.r then rectfill(fx+7,fy+2,fx+7,fy+4) end
        local px=8*flr(player.p.x/16)
        local py=8*flr(player.p.y/14)
        if py>=0 and time()%1<.5 then rectfill(px+1,py-23,px+5,py-19,9) end
      end
    end
  end

  hudrow(0,g_health,g_maxh,69,10)
  hudrow(64,g_webs,g_maxwebs,70,3)

  printd(g_message,0,129-abs(g_message_t))
end

function hudrow(x,val,mx,on,off)
  for i=1,mx do
    if i>val then spr(on,x,0)
    else spr(off,x,0) end
    x+=8
  end
end

function setchannels(bits)
  for p=0x3110,0x31ff do
    if 1<<p%4&bits>0 then poke(p,peek(p)&191)
    else poke(p,peek(p)|64)
    end
  end
end

function _init()
  cartdata("twinbeard_gordy_0")
  decodemap()
  initobjects()

  pumpkin(g_spawner.p):respawn()

  changerooms()

  poke(0x5f5c,255)
  if dget(0)!=0 then storyexec("continue")
  else storyexec()
  end
end

-->8
function v(x,y)
  if not y then return {x=x.x,y=x.y} end
  return {x=x,y=y}
end

function vadd(a,b)
  return v(a.x+b.x,a.y+b.y)
end

function vsub(a,b)
  return v(a.x-b.x,a.y-b.y)
end

function vmul(a,b)
  return v(a.x*b,a.y*b)
end

function vdiv(a,b)
  return v(a.x/b,a.y/b)
end

function cw(p)
  return v(-p.y,p.x)
end

function veq(a,b)
  return a.x==b.x and a.y==b.y
end

function veqz(a)
  return a.x==0 and a.y==0
end

function vmag(a)
  return sqrt(a.x*a.x+a.y*a.y)
end

function vnorm(a)
  return vdiv(a,vmag(a))
end

function vzero()
  return v(0,0)
end

function rndir(m)
  return vmul(v(rnd()-.5,rnd()-.5),m or 1)
end

-->8
function mapset(x,y,t)
  g_m[flr(y)+1][flr(x)+1]=t
end

function mapat(x,y)
  return g_m[flr(y)+1][flr(x)+1]
end

src=8192
bit=256
lookup={}

function nextval()
  local val=0
  local i=0
  local n
  repeat
    i+=1
    n=0
    for j=i-1,0,-1 do
      if (bit==256) then
        bit=1
        src+=1
        if src==0x3000 then src=0x1000 end
        byte=peek(src)
      end
      if (byte&bit)>0 then
        n+=(1<<j)
      end
      bit*=2
    end
    val+=n
  until n!=2^i-1
  return val
end

function decodemap()
  local t
  repeat
    t=peek(src)
    src+=1
    add(lookup,t,1)
  until t==0

  src-=1

  local tt=0
  local row={}
  local y=0
  repeat
    local nv=nextval()
    local c=nextval()
    local t=lookup[nv+1]
    tt+=c
    if t>0 then t-=1 end
    for i=1,c do
      add(row,t)
      if count(row)==256 then
        g_m[y+1]=row
        y+=1
        row={}
      end
    end
  until y==224

  for x=0,255 do
    for y=0,223 do
      t=mapat(x,y)
      if t>64 and not (t>=75 and t<=79) then
        mapset(x,y,t)
        local n=y
        while mapat(x,n)!=t-64 and n<224 do
          mapset(x,n,t-64)
          n+=1
        end
      end
    end
  end
end

-->8
compass={v(0,-1),v(1,0),v(0,1),v(-1,0)}

function drawguy(t,p,o)
  drawguyflip(t,p,false,o)
end

function drawguyflip(t,p,hf,o)
  o=o or vzero()
  spr(t,p.x*8-4+o.x,p.y*8-4+o.y,1,1,hf)
end

function butnany()
  for i=0,5 do
    if butn(i) then return true end
  end
end

function butn(n)
  for i=0,7 do
    if btn(n,i) then return true end
  end
end

function butnp(n)
  for i=0,7 do
    if btnp(n,i) then return true end
  end
end

function pumpkin(p)
  p=entity(p,v(.6,.6))
  p.name="pumpkin"
  player=p
  p.op=v(p.p)
  g_maxwebs=0
  g_maxh=3
  g_facing=v(1,0)
  g_flame_t=0
  g_flame_c=8
  g_die_t=0
  g_seeds=0
  p.respawn=function(_)
    g_underw=false
    if _.p.y<112 and not _.candle then
      message("too dangerous. you need a light.")
    elseif g_maxwebs>0 and g_webs<g_maxwebs then
      message("your webs return to you.")
    else
      message("you wake feeling rested.")
    end
    g_bounce_t=0
    g_damage_t=0
    g_celeb_t=0
    g_webs=g_maxwebs
    g_health=g_maxh
    _.p=v(g_spawner.p)
    _.vel=vzero()
    for id,r in pairs(g_rooms) do
      restartroom(r,true)
    end
    g_resting=true
    g_sincerest=0
    if g_web then g_web.remove=true end
    g_web=nil
  end
  p.restart=nil
  p.draw=function(_)
    if g_damage_t%6>3 or g_resting and g_sincerest%30>15 then return end
    if g_die_t>0 then
      drawguy(0,_.p)
      return
    end
    if g_underw then g_yo=sin(g_bounce_t/40)*.1
    else
      g_yo=abs(sin(g_bounce_t/16)*(abs(_.vel.x)+abs(_.vel.y)))
    end
    drawguy(16,_.p)
    local vo=v(0,-g_yo*20)
    drawguy(1,_.p,vo)
    if not g_resting then
      pal(7,g_flame_c)
      drawguy(2,_.p,vo)
      pal()
    end
    if g_celeb_t>0 then
      drawguy(g_celebrating,_.p,v(0,-8))
    end
  end
  p.celebrate=function(_,s)
    g_damage_t=0
    g_celebrating=s
    g_celeb_t=45
  end
  p.damagetick=function(_)
    _.vel=vmul(_.vel,.95)
    g_bounce_t=0
  end
  p.celebtick=function(_)
    _.vel=vmul(_.vel,.8)
    _:move()
    g_bounce_t=0
  end
  p.tick=function(_)
    g_sincerest+=1
    if g_resting then
      if butnany() then
        g_resting=false
      else
        return
      end
    end
    if _.boots then
      _.cmask=5
    end
    g_flame_t+=1
    if g_die_t>0 then
      g_die_t-=1
      if g_die_t==0 then
        _:respawn()
      end
      _.vel=vmul(_.vel,.8)
      _:move()
      return
    end
    if g_flame_t%3==0 or g_celeb_t>0 then
      if _.candle then
        local last=g_flame_c
        repeat
          g_flame_c=rnd({2,5,7,8,10})
        until g_flame_c!=last
      else g_flame_c=0 end
    end
    if g_celeb_t>0 then
      g_celeb_t-=1
      _:celebtick()
      return
    end
    if g_damage_t>0 then
      g_damage_t-=1
      _:damagetick()
    end
    if g_damage_t>15 then
      _:move()
      return
    end
    _.vel=vmul(_.vel,.5)
    local accel=.1
    if _.atop==20 or _.atop==5 then accel*=.75 end
    g_a=vzero()
    if butn(0) then g_a.x=-accel end
    if butn(1) then g_a.x=accel end
    if butn(2) then g_a.y=-accel end
    if butn(3) then g_a.y=accel end
    if butnp(4) then
      _:fireweb()
    end
    if g_a.x!=0 and g_a.y!=0 then
      g_a=vdiv(g_a,1.4142)
    end
    if not veqz(g_a) then
      g_facing=vdiv(g_a,accel)
    end
    _.vel=vadd(_.vel,g_a)
    _:move()
    if _.blocklist[38] and _.boots then
      if _.scuba then
        ?"\as4v5i6c0i1x3g"
        if player.p.y>=112 then
          player.p.y-=112
          g_underw=true
          message("you dive under the water.")
        else player.p.y+=112 end
      else message("this water is too deep to wade.")
      end
    end
    if abs(_.vel.x)<.01 then _.vel.x=0 end
    if abs(_.vel.y)<.01 then _.vel.y=0 end
    if veqz(_.vel) then g_bounce_t=0
    else g_bounce_t+=1
    end
    if g_bounce_t>0 and g_bounce_t%8==0 then
      local t=_.atop
      if waters[t] then
        ?"\as4v2i6c0v4i1x3gi6v1x4c2g4"
        for i=0,4 do
          insertent(particle(_.p,t))
        end
      elseif t==61 then
        ?"\as4v5i6c0i1x3g"
        insertent(footprint(_.p,64))
      elseif not g_underw then
        ?"\ai0v5x3g0"
      end
    end
  end
  p.damage=function(_,from)
    if g_damage_t==0 and g_die_t==0 and g_celeb_t==0 then
      g_health-=1
      _.vel=vmul(vsub(_.p,from.p),.45)
      if g_health==0 then
        ?"\as9i0x3g2c1g0"
        g_die_t=60
        message("smushed by a biohazard.")
      else
        ?"\as3i1v5x2c0f0c0f0a0c1a0c1"
        g_damage_t=30
      end
    end
  end
  p.fireweb=function(_)
    if g_web then
      return
    end
    if g_webs==0 then
      if g_maxwebs>0 then
        message("you are out of webs.")
      end
      return
    end
    ?"\as9v5i6x4c"
    g_web=web(_.p,g_facing)
    g_webs-=1
    addent(g_web)
  end
  return p
end

function footprint(p,t)
  o=entity(p)
  o.color=6
  o.lifetime=300
  o.draw=function(_)
    if not t then pset(_.p.x*8,_.p.y*8,_.color)
    else drawguy(t,_.p)
    end
  end
  o.restart=function(_)
    _.remove=true
  end
  o.tick=function(_)
    if _.timer>=_.lifetime then
      _.remove=true
    end
  end
  return o
end

function smoke(p,c)
  o=footprint(vadd(p,rndir(.5)))
  o.color=c or 5
  o.lifetime=20
  o.vel=v(0,-.06)
  o.oldtick=o.tick
  o.tick=function(_)
    _.vel.x+=rnd(.01)-.005
    _.p=vadd(_.p,_.vel)
    _:oldtick()
  end
  return o
end

function particle(p,t)
  o=entity(p)
  o.blue=t==5 or t==22
  o.height=0
  if t==0 then
    o.hv=2
    o.g=.125
    o.vel=rndir(.3)
  else
    o.hv=1
    o.g=.25
    o.vel=rndir(.2)
  end
  o.restart=function(_)
    _.remove=true
  end
  o.draw=function(_)
    if _.blue then
      pal(11,13)
      pal(3,1)
    end
    drawguy(32,_.p,v(0,-_.height))
    pal()
  end
  o.tick=function(_)
    _.p=vadd(_.p,_.vel)
    _.height+=_.hv
    _.hv-=_.g
    if _.height<0 then
      _.remove=true
    end
  end
  return o
end

function web(p,vel)
  o=entity(vadd(p,vdiv(vel,2)),v(.5,.5))
  o.cmask=1
  o.name="web"
  o.rewind=0
  o.vel=v(vel)
  o.sticky=true
  o.draw=function(_)
    line(_.p.x*8,_.p.y*8,player.p.x*8,player.p.y*8-g_yo*20,6)
    drawguy(3,_.p)
  end
  o.vanish=function(_)
    _.remove=true
    g_webs+=1
    g_web=nil
  end
  o.tick=function(_)
    if _.rewind>0 then
      local diff=vsub(_.p,player.p)
      diff=vmul(diff,_.rewind)
      if abs(diff.x)+abs(diff.y)<1 then
        _:vanish()
      end
      _.p=vadd(player.p,diff)
      _.rewind=max(_.rewind-0.05,0)
    else
      local ov=v(_.vel)
      _:move(.5)
      if ov.x!=_.vel.x or ov.y!=_.vel.y then
        _.rewind=.9
      end
    end
    if not _.sticky then
      _.remove=true
      g_web=nil
      message("your web burns up in the flame.")
    end
  end
  return o
end

function touchable(p,s,i)
  t=entity(p,s)
  t.offset=vzero()
  t.draw=function(_)
    drawguy(i,_.p,_.offset)
    if _.drawbelow then
      drawguy(_.drawbelow,vadd(_.p,v(0,1)))
    end
  end
  t.touch=function(_) end
  t.trytouch=function(_)
    if collide(_.p,_.size,player.p,player.size) then
      _:touch()
    end
  end
  t.tick=function(_)
    _:trytouch()
  end
  return t
end

function dad(p)
  _=touchable(p,v(1,1),79)
  _.name="dad"
  _.tick=function(_)
    local touch=collide(_.p,_.size,player.p,player.size)
    if touch and not last_touch then
      storyexec("chat")
    end
    last_touch=touch
  end
  return _
end

function collectible(p,t)
  o=touchable(p,v(1,1),t)
  if t==72 then
    o.drawbelow=34
  end
  o.init=function(_)
    registersave(_)
  end
  o.activate=function(_)
    if t==3 then
      g_maxwebs+=1
      g_webs=g_maxwebs
    elseif t==10 then
      g_maxh+=1
      g_health=g_maxh
    else
      player[dict("14,boots,29,candle,51,scuba,55,sight,59,atlas,60,map,72,lollipop")[t]]=true
    end
    _.remove=true
    save(_)
  end
  o.tick=function(_)
    _.offset.y=sin(time()/4)*1.5
    _:trytouch(_)
  end
  o.touch=function(_)
    if _.timer<20 and t==72 then return end
    if t==3 or t==10 then
      ?"\as8i0x2e2f#gbbbbbbb"
    else
      ?"\as8i0x2e2f#gbe3f#f#f#f#f#f#f#"
    end
    if t==3 then
      if g_maxwebs==0 then message("press \142/z to throw webs.")
      else
        message("you can make more things sticky.")
      end
    else
      message(dict("10,candy corn! you feel healthier.,14,you put on the wading boots.,51,the scuba mask fits snugly.,55,you drink the potion of sight.,59,a guide to hidden places.,60,hold \151/x to see the map.,72,this candy is dangerously sweet.")[t])
    end
    _:activate()
    if t==29 then
      player:celebrate(13)
      message("a light in the dark.")
    else
      player:celebrate(t)
    end
  end
  return o
end

function drawfire(p)
  if p.onfire then
    drawguyflip(17,p.p,time()%.2<.1)
  end
end

function hazard(p,t)
  h=touchable(p,v(.8,.8),t)
  h.hazard=true
  h.t=t
  h.frames=#t
  h.frametime=rnd(h.frames)
  h.framespeed=.1
  h.restart=function(_)
    if not _.sticky then
      _.p=v(_.op)
      _.vel=v(_.ov)
    end
  end
  h.draw=function(_)
    local s=_.t
    if type(s)=="table" then
      s=_.t[flr(_.frametime)+1]
    end
    drawguyflip(s,_.p,_.hflip)
    if _.sticky then
      drawguy(3,_.p)
    end
    drawfire(_)
  end
  h.touch=function(_)
    if not _.safe or _.onfire then
      player:damage(_)
    end
  end
  h.checkfire=function(_)
    for e in all(g_ents) do
      if e.hazard or e.sticky then
        if e!=_ and not waters[e.atop] and not e.onfire and vmag(vsub(_.p,e.p))<1.2 then
          e.onfire=true
          if e.sticky then
            for i=1,20 do
              add(g_ents,smoke(vadd(e.p,rndir())))
            end
          end
          ?"\ai6x1v0c0v1cv2cv3ccc"
          e.sticky=false
        end
      end
    end
  end
  h.checksticky=function(_)
    for e in all(g_ents) do
      if e!=_ and e.sticky and vmag(vsub(_.p,e.p))<1.2 then
        if e.name=="web" then
          message("the web sticks to the biohazard.")
          e.remove=true
          g_web=nil
        end
        _.sticky=true
        ?"\as0i6c0v0cccccccv6cv0cccv6cv0ccccv6c"
        return
      end
    end
  end
  h.tick=function(_)
    _.frametime+=_.framespeed
    _.frametime%=#t
    if _.sticky then return end
    if _.think!=nil then
      _:think()
    end
    if _.onfire then
      if waters[_.atop] then
        _.onfire=false
        ?"\ai6x4v4c3x0c3cv3cv2cv1c"
        for i=1,20 do add(g_ents,smoke(vadd(_.p,rndir()),7)) end
      else
        _:checkfire()
        if rnd()>.3 then add(g_ents,smoke(_.p)) end
      end
    end
    if _.vel.x>0 then _.hflip=true end
    if _.vel.x<0 then _.hflip=false end
    _:trytouch()
    if not _.onfire then _:checksticky() end
  end
  return h
end

function fencebot(p)
  b=hazard(p,{8,24})
  b.init=function(_)
    local f=v(0,-1)
    while not solid(_.p.x+f.x,_.p.y+f.y) do
      f=cw(f)
    end
    _.vel=v(f)
    _.fence=v(f)
    _:move()
    _.vel=cw(f)
    _.op=v(_.p)
    _.ov=v(_.vel)
    _.of=v(_.fence)
  end
  b.restart=function(_)
    if not _.sticky then
      _.p=v(_.op)
      _.vel=v(_.ov)
      _.fence=v(_.of)
    end
  end
  b.think=function(_)
    local old_vel=v(_.vel)
    _.vel=v(_.fence)
    _:move(.25)
    if _.vel.x!=0 or _.vel.y!=0 then
      _.fence=v(_.vel.y,-_.vel.x)
      return
    end
    _.vel=old_vel
    _:move(.25)
    if _.vel.x==0 and _.vel.y==0 then
      _.fence=cw(_.fence)
      _.vel=cw(_.vel)
    end
  end
  return b
end

function ghost(p)
  o=hazard(p,{26,42})
  o.framespeed=.04
  o.think=function(_)
    local pp=player.p
    local p=_.p
    local vel=_.vel
    if pp.x>p.x and vel.x< 1 then vel.x+=.0625 end
    if pp.x<p.x and vel.x>-1 then vel.x-=.0625 end
    if pp.y>p.y and vel.y< 1 then vel.y+=.0625 end
    if pp.y<p.y and vel.y>-1 then vel.y-=.0625 end
    _.p=vadd(p,vmul(vel,.04))
  end
  return o
end

function pacebot(p)
  b=hazard(p,{9,25})
  b.vel=vzero()
  b.init=function(_)
    local px=p.x
    local py=p.y
    local vel=v(1,0)
    while not solid(px-vel.x,py-vel.y) do vel=cw(vel) end
    _.vel=vel
    _.op=v(_.p)
    _.ov=v(_.vel)
  end
  b.think=function(_)
    local oldv=v(_.vel)
    _:move(.25)
    if _.vel.x==0 then _.vel.x=-oldv.x end
    if _.vel.y==0 then _.vel.y=-oldv.y end
  end
  return b
end

function spawner(p,t)
  o=entity(p)
  o.name="spawner"
  o.last_touchp=true
  o.leafgrow=32
  if t>0 then
    g_spawner=o
    o.leafgrow=0
  end

  o.draw=function(_)
    drawguy(11,_.p)
    if _==g_spawner then
      local s=8-_.leafgrow/4
      sspr(96,0,8,8,_.p.x*8,_.p.y*8-s,s,s)
    end
  end
  o.tick=function(_)
    if _.leafgrow>0 then
      _.leafgrow-=2
    end
    touchp=collide(_.p,_.size,player.p,player.size)
    if g_spawner!=_ and touchp then
      ?"\asfi0c2x1d2e2"
      message("a leaf unfurls. it's comfy!")
      g_spawner=_
      _.leafgrow=32
    end
    if touchp then
      if not _.last_touchp and (g_webs<g_maxwebs or g_health<g_maxh) then
        message("press \151/x at the leaf to rest.")
      end
      if butnp(5) then
        player:respawn()
      end
    end
    _.last_touchp=touchp
  end
  return o
end

function ladder(p,t)
  o=entity(p)
  o.name="ladder"
  o.draw=function(_)
    drawguy(t,_.p)
  end
  o.tick=function(_)
    if not collide(_.p,_.size,player.p,player.size) then
      g_on_ladder=false
    elseif not g_on_ladder then
      if g_underw then
        music(32)
        player:respawn()
        storyexec("ending")
        return
      end
      g_on_ladder=true
      ?"\ai6x5s0c3v0s6cv6s0c2v0s6cs1v6c1v0s6cv6s1c0"
      player.vel=vzero()
      g_bounce_t=0
      player.p=v(_.p)
      if _.p.y>=112 then
        player.p.y-=111.5
        if not player.candle then message("it's very dark.")
        else messageonce("your candle lights up the dark.")
        end
      else
        message("you emerge into the starlight.")
        player.p.y+=112.5
      end
    end
  end
  return o
end

function cryo(p,t)
  o=entity(p)
  o.init=function(_)
    _.name="cryo"
    _.emerge=0
    if t==35 then _.emerge=8 end
    registersave(_)
  end
  o.activate=function(_)
    _.remove=true
    if _.p.y<112 then
      player.lollipop=true
    else
      g_seeds+=1
      for i=0,43 do
        _:newpatch(i)
      end
      addent(spawner(_.p,-1))
    end
  end
  o.draw=function(_)
    local t
    if _.emerge>=16 then t=34
    elseif _.emerge>=8 then t=35
    elseif _.emerge==0 then t=33
    end
    if t then
      drawguy(t,_.p)
    end
    if _.emerge<8 then
      sspr(24,16,8,_.emerge,_.p.x*8-4,_.p.y*8+4-_.emerge,8,_.emerge)
    end
  end
  o.tick=function(_)
    local touch=collide(_.p,_.size,player.p,player.size)
    local newtouch=touch and not _.lasttouch
    _.lasttouch=touch
    if _.emerge>0 then
      if _.emerge<8 then
        _.emerge+=.25
      elseif _.emerge<16 then
        if touch then
          save(_)
          if _.p.y<112 then
            _.remove=true
            ?"\as8i6v5c0c4c0"
            message("you activate the... uh...")
            addent(collectible(vadd(_.p,v(0,-1)),72))
            return
          end
          _.emerge=16
          ?"\as8i6v2c0c4c0v0cci0v3c1x1c2c3c4x0dcdcdcdcdcdc"
          message("you activate the seed emitter.")
          g_seeds+=1
        end
      elseif _.emerge<60 then
        _:newpatch(_.emerge-16)
        _.emerge+=1
        addent(particle(_.p,0))
      else
        addent(spawner(_.p,-1))
        _.remove=true
        calcmap()
      end
      return
    end
    if newtouch then
      message("a cryo pod buried itself here.")
    end
    local safe=true
    for e in all(g_ents) do
      if e.hazard and e.sticky==false then
        safe=false
      end
    end
    if safe then
      ?"\as4i0x2c0c1c0c1c#0c#1d0d1d0d1d#0d#1d#0d#1"
      _.emerge=1
      message("the cryo-pod senses safety.")
    end
  end
  o.newpatch=function(_,n)
    local r=room(_.p)
    srand(r.x+r.y*16+n)
    local scale=n/4
    local x=flr(_.p.x+rnd(scale)-scale/2)
    local y=flr(_.p.y+rnd(scale)-scale/2)
    if fget(mapat(x,y))&9 then
      mapset(x,y,45,true)
      if x%16==0 then mapset(x-1,y,45) end
      if x%16==15 then mapset(x+1,y,45) end
      if y%14==0 then mapset(x,y-1,45) end
      if y%14==13 then mapset(x,y+1,45) end
    end
  end
  return o
end

function ship(p)
  o=entity(p,v(1.5,1.5))
  o.name="ship"
  o.draw=function(_,px,py)
    local v=22-g_seeds
    local s="ready"
    if v>0 then s=""..v end
    rectfill(px-8,py+8,px+15,py+31,0)
    print(s,px+4-(#s*2),py+17,7)
  end
  o.tick=function(_)
    messageonce("oh, there's lander b.")
    local touch=collide(_.p,_.size,player.p,player.size)
    if touch and not _.lasttouch then
      if g_seeds>=22 then
        _.remove=true
        mapset(_.p.x,_.p.y,0)
        addent(ladder(v(_.p.x,_.p.y+2),19))
        ?"\as4v5x3i6c1c3"
        message("the hatch opens.")
      else
        ?"\as7i0f0v0fv6ff"
        message("lander b won't let you in.")
      end
    end
    _.lasttouch=touch
  end
  return o
end

waters=dict("5,t,22,t,20,t,37,t")
rounded=dict("5,t,22,t,20,t,37,t,61,t")

function hand(p)
  o=hazard(p,{56,57})
  o.cmask=17
  local olddraw=o.draw
  o.draw=function(_)
    if player.sight then olddraw(_) end
    drawfire(_)
  end
  o.think=function(_)
    if sticky then return end
    local vec=vsub(player.p,_.p)
    local vm=vmag(vec)
    _.vel=vmul(vadd(_.vel,vdiv(vec,vm*200)),.98)
    _:move()
    local t=_.atop
    if rnd()<.5 and waters[t] then
      insertent(particle(_.p,t))
    end
    if rnd()<.25 and t==61 then
      insertent(footprint(vadd(_.p,vmul(rnd(compass),.25))))
    end
  end
  return o
end

function zombie(p)
  o=hazard(p,{40,41})
  o.frametime=0
  o.restart=function(_)
    if not _.sticky then
      _.p=v(_.op)
      _.vel=vzero()
      _.frametime=0
    end
  end
  o.think=function(_)
    if sticky then return end
    local vec=vsub(player.p,_.p)
    local vm=vmag(vec)
    if vm<6 then
      _.vel=vadd(_.vel,vdiv(vec,vm*240))
      _.framespeed=.1
    elseif abs(_.vel.x)+abs(_.vel.y)<.01 then
      _.vel=vzero()
      _.framespeed=0
      _.frametime=0
    end
    _.vel=vmul(_.vel,.98)
    _:move()
  end
  return o
end

function fish(p)
  o=hazard(p,{43,44})
  o.swim_t=flr(rnd(16)+64)
  o.think=function(_)
    if g_underw then
      _.cmask=1
    else
      _.cmask=9
    end
    _.swim_t-=1
    if _.swim_t==0 then
      _.swim_t=flr(rnd(16)+64)
      _.vel=vzero()
    elseif _.swim_t<40 then
      _.framespeed=.1
      _.vel=vmul(_.vel,.95)
    elseif _.swim_t==60 then
      _.framespeed=.5
      if rnd()<.3 then
        _.dir=rndir()
      else
        _.dir=vnorm(vsub(player.p,_.p))
      end
      _.dir=vmul(_.dir,.02)
    elseif _.swim_t<60 then
      _.vel=vadd(_.vel,_.dir)
    end
    _:move()
    if vmag(vsub(player.p,_.p))<.9 then
      _:touch()
    end
  end
  return o
end

function spinner(p,t)
  o=hazard(p,{t})
  o.init=function(_)
    _.subs={}
    _.a=0
    local i=1
    local px=_.p.x
    local py=_.p.y
    repeat
      local s=hazard(v(px+i,py),{t})
      add(_.subs,s)
      add(roompool(_.p),s)
      i+=1
    until t==30 and mapat(px+i,py)!=0 or t!=30 and mapat(px,py+i)!=0
  end
  o.restart=function(_)
    if not _.sticky then
      _.a=0
      _:think()
    end
  end
  o.think=function(_)
    if t==30 then
      _.a-=.008
    else
      _.a+=.006
    end
    local d=1
    local w=v(cos(_.a),sin(_.a))
    for s in all(_.subs) do
      s.p=vadd(_.p,vmul(w,d))
      d+=1
    end
  end
  return o
end

function witch(p)
  o=hazard(p,{27})
  o.cmask=1
  o.turn=0
  o.restart=function(_)
    if not _.sticky then
      _.p=v(_.op)
      _.fade=rnd(100)
      _.turn=0
    end
  end
  o.think=function(_)
    _.fade=(_.fade+.5)%100
    if player.sight then
      _.fade=20
    end
    _.safe=_.fade>=60
    _.turn-=1
    local w=vsub(player.p,_.p)
    local close=abs(w.x)<.5 or abs(w.y)<.5
    if _.turn<=0 or veqz(_.vel) or _.turn<40 and close then
      _.turn=50+rnd(50)
      local s=.1
      if rnd()<.7 then
        if abs(w.x)>abs(w.y) then
          _.vel=v(sgn(w.x)*s,0)
        else
          _.vel=v(0,sgn(w.y)*s)
        end
      else
        _.vel=vmul(rnd(compass),s)
      end
    end
    _:move(1.5)
    if _.fade>50 and _.fade<=60 or _.fade<10 then
      _.t={28}
    elseif _.fade>10 and _.fade<=50 then
      _.t={27}
    else
      _.t={82}
    end
  end
  return o
end

spawnlookup={
  ["c"]=collectible,
  ["f"]=fencebot,
  ["p"]=pacebot,
  ["s"]=spawner,
  ["l"]=ladder,
  ["g"]=ghost,
  ["w"]=witch,
  ["S"]=spinner,
  ["C"]=cryo,
  ["z"]=zombie,
  ["h"]=hand,
  ["d"]=dad
}

tileobj=dict("3,c,8,f,9,p,10,c,12,s,14,c,18,l,19,l,26,g,27,w,29,c,30,S,33,C,35,C,40,z,51,c,55,c,56,h,59,c,60,c,62,S,79,d")

function initobjects()
  local x,y

  g_a=vzero()

  for x=0,255 do
    for y=0,223 do
      local t=mapat(x,y)
      local e
      local r
      local rf=0
      local p=v(x+.5,y+.5)
      if t==27 or t==56 then
        rf=10
      end
      if t==31 then
        e=ship(p)
        r=31
      end
      if t==43 then
        e=fish(p)
        rf=2
      end
      if not e and tileobj[t] then
        e=spawnlookup[tileobj[t]](p,t)
      end
      if e then
        if not r then
          r=0
          for d in all(compass) do
            local t=mapat(x+d.x,y+d.y)
            if fget(t)&rf>0 then
              r=t
              break
            end
          end
        end
        mapset(x,y,r)
        if mapat(x,y-1)==17 then
          e.onfire=true
          mapset(x,y-1,0)
        end
        e.oldonfire=e.onfire
        if t==33 then insertent(e)
        else addent(e) end
      end
    end
  end

  flushinsert()

  for x=0,15 do
    for y=0,15 do
      for e in all(roompool(v(x*16,y*14))) do
        if e.init then e:init() end
      end
    end
  end
end

dustpal={12,6,5,13}
dust={}
for i=1,64 do add(dust,{v(rnd(128),rnd(128)),rndir(5)}) end

function drawdust()
  local n=0
  for d in all(dust) do
    pset(d[1].x,d[1].y,dustpal[flr(sin(time()/10+n/12)*1.98)+3])
    n+=1
    d[1]=vadd(d[1],vmul(d[2],.1))
    d[1].x%=128
    d[1].y%=128
    d[2]=vmul(vadd(d[2],rndir()),.95)
  end
end

-->8
menu={}

function startmenu(t)
  local text="\""
  for i in all(t) do
    if text!="\"" then
      text..="\n"
    end
    text..=i
  end
  menu={}
  menusay=text.."\""
  menusayp=0
  menupos=0
  menuoff=0
  g_dlist={}
end

function printd(s,x,y)
  print(s,x+1,y+1,1)
  print(s,x,y,9)
end

function drawmenu()
  local s=sub(menusay,1,menusayp)
  printd(s,0,0)
  local menuy=128-#menu*8
  if time()%1<.5 then
    printd("▶",0,menupos*8+menuy+menuoff)
  end
  for m in all(menu) do
    printd(m[1],8,menuy+menuoff)
    menuy+=8
  end
end

function tickmenu()
  menusayp+=3
  if menusayp>#menusay then
    menusayp=#menusay
    if menuoff>0 then menuoff-=2 end
  elseif menusayp%6==0 then ?"\as2i0g0"
  end
  local menudir=0
  if butnp(2) and menupos>0 then menudir=-1
  elseif butnp(3) and menupos<#menu-1 then menudir=1
  end
  repeat menupos+=menudir
  until menudir==0 or menu[menupos+1][2]!="cursorskip"
  if butnp(4) and menuoff==0 then
    storyexec(menu[menupos+1][2])
  end
end

function begin()
  g_menu=false
  music(0)
end

function storyexec(label)
  g_menu=true
  player.skully=seen(v(224,112))
  player.landy=seen(v(144,182))
  local i=1
  while true do
    if label then i=1 end
    while label do
      if story[i]=="l "..label then label=nil end
      i+=1
    end
    local cmd=story[i]
    local c=sub(cmd,1,1)
    local p=sub(cmd,3)
    local x=split(p,"|")
    if c=="s" then
      startmenu(x)
    elseif c=="!" then
      player[p]=true
    elseif c=="?" then
      bool=player[x[1]]
      if bool and x[2]!="" then
        label=x[2]
      elseif not bool and x[3]!="" then
        label=x[3]
      end
    elseif c=="g" then
      add(g_dlist,x)
    elseif c==">" then
      label=p
    elseif c=="o" then
      add(menu,{x[2],x[1]})
      menuoff+=8
    elseif c=="d" then
      if g_m[1]==nil then
        menuoff+=2
      end
      return
    elseif c=="n" then
      begin()
      g_savepos=0
      for i=0,63 do
        dset(i,0)
      end
      seen(player.p,true)
      return
    elseif c=="c" then
      begin()
      loading=true
      while dget(g_savepos)>0 do
        local s=g_savable[dget(g_savepos)]
        if s!=nil then
          s:activate()
        end
        g_savepos+=1
      end
      loading=false
      calcmap()
      return
    elseif c=="e" then
      g_finito=true
      return
    elseif c=="r" then
      g_menu=false
      message("good luck out there!")
      return
    end
    i+=1
  end
end

story=split(
"l restart\ns i've got a new one tonight.|it's a halloween adventure|called 'gordy and the monster|moon.' are you ready?\ng 0|88|use the arrow keys to move the\ng 0|94|cursor and \142/z to choose.\ng 80|32|28|4|3\ng 88|32|52|8|3\ng 84|64|44|1|2\ng 85|72|52|3|2\no start|yeah!\no start|... i'll allow it.\no gordy|\"gordy?\"\nd\nl gordy\ns yeah like the name gordy, but|also because a gourd is a|squash. like a pumpkin.\no start|i know what a gourd is.\no jack|oh, like a jack-o-lantern?\no start|okay, sure.\nd\nl jack\ns yeah, like a jack-o-lantern|going on an adventure.\no start|okay, i get it.\no start|that's adorable. let's do it.\nd\nl continue\ns do you remember where we were?|do you want to keep going or|start over?\ng 0|88|use the arrow keys to move the\ng 0|94|cursor and \142/z to choose.\ng 80|32|28|4|3\ng 88|32|52|8|3\ng 84|64|44|1|2\ng 85|72|52|3|2\no load|i want to keep going!\no restart|start over!\nd\nl start\ns okay, so you're a pumpkin|astronaut named gordy and|you're descending to a strange|moon you just discovered. uh|oh! you hit a patch of|turbulence and your lander|spins out of control! your seed|cryo-pods fly off in every|direction.\no land|i try to right the lander!\no land|i brace for impact!\no space|this is a halloween story??\nd\nl space\ns it's called a 'mash-up.' i|guess it's from before your|time. just roll with it. so|your lander crashes in a|forest. you're only a bit|bruised, but there's no way the|lander will take off again.|hopefully lander b found a safe|landing zone.\no mashup|i know what a mash-up is!\nl stuff\no lander|what's in lander b?\no lander|what are the cryo-pods for?\no hatch|open the hatch and explore!\nd\nl mashup\ns you wouldn't be my kid if you|didn't!\n> stuff\nl land\ns it's no use! your lander|crashes in a forest and you|roll across the cabin floor.|you're only a bit bruised, but|there's no way the lander will|take off again. hopefully|lander b found a safe landing|zone.\no lander|so why am i here?\n> stuff\nl lander\ns life is a mystery! sometimes|you have to figure things out|for yourself.\no framework|you don't know yet, right?\no hatch|okay, fine. let's explore.\nd\nl framework\ns i have a, you know, a loose|framework that i'm working|from. sometimes the details|need time to gel. but sometimes|-- sometimes! -- i'm holding|details back because it's fun.|and i'll never tell you which|it is!\no hatch|okay, okay. let's explore.\nd\nl hatch\nn\nl load\nc\nl ending\ns kid, i'm falling asleep even if|you're not, so i'm gonna call|it for tonight. can we pick it|up tomorrow?\no what|huh? you can't leave it there!\no night|okay, i guess.\nd\nl what\ns oh, uh, i guess you go into|lander b and see that all the|cryo-pods are safe, so you can|move forward with terraforming|the monster moon.\no ruin|and ruin this cool moon??\no terra|nice! pumpkin moon!\n? skully||noskull\no skully|what was that underwater face?\nl noskull\no terraforming|what's \"terraforming\" mean?\no flying|who was flying lander b?\nd\nl skully\ns it's just a face! i just|thought something needed to go|there. it was supposed to be|interesting enough to not be a|boring dead end but not enough|to look like a puzzle or|anything.\no terraforming|what's \"terraforming\" mean?\no flying|who was flying lander b?\nd\nl flying\ns i guess it was autonomous? or,|no, this is better, as you're|examining the cryo-pods another|pumpkin comes out of the|bathroom and is like 'oh hello|captain, we've been waiting for|you! we need your credentials|to activate the terraforming|process.'\no ruin|and ruin this cool moon??\no terra|nice! pumpkin moon!\no terraforming|what's \"terraforming\" mean?\nd\nl terraforming\ns it's sci-fi technology. terra|comes from greek, or maybe|latin, i forget, for 'earth.'|so to terraform is to reshape a|world that's hostile to us to|be habitable for us. fix the|atmosphere, temperature, the|ecology so we can live there.\no seemed|but the pumpkin seemed fine?\no terra|i wanna do it!\no instead|i don't want to do that!\nd\nl seemed\ns yeah, i mean, just imagine the|pumpkin was wearing a space|helmet. or maybe the pumpkin|*was* the space helmet and you|were the alien creature inside.|anyway, do you want to|terraform the monster moon?\no terra|i wanna do it!\no instead|i don't want to do that!\nd\nl ruin\ns well, it's up to you! it's your|story. do you want to terraform|this moon?\no terraforming|what's \"terraform\" mean?\no terra|i wanna do it!\no instead|i'm not gonna do it.\nd\nl instead\ns instead of terraforming the|moon you lift off into space|and head back to your home|planet to tell everyone about|the cool halloween moon you|visited.\no okay|neat!\no all|then what happens?\nd\nl terra\ns your seeds cover the monster|moon and pumpkins come to|dominate the ecosystem. that's|called an 'invasive species!'|like the tree of heaven mom was|talking about.\no okay|neat!\no all|then what happens?\nd\nl all\ns that's all i got. i'm making|this up as i go! can we do more|story tomorrow?\no okay|okay, dad.\nd\nl okay\ns okay, it's late! i have to get|to bed too. night, kiddo! love|you!\n> endopts\nd\nl night\ns night, kiddo! love you!\nl endopts\no end|night, dad.\no end|love you too, dad.\nd\nl end\ns sleep well, toby.\ng 80|32|16|4|3\ng 88|32|40|8|3\ng 117|40|24|3|1\ng 117|40|32|3|1\ng 117|40|40|3|1\ng 48|28|the end\ng 12|70|gordy and the monster moon\ng 12|77|created by jim stormdancer\ng 26|84|music by danny aley\ng 8|91|bedtime art by tyriq plummer\no load|wake up and keep exploring!\nd\nl chat\n? chatimmediate|chatimmediate|\ns ah, there you are!\no hi|hi, dad!\no monster|dad, are you a monster too?\no putself|you put yourself in the game??\nd\nl hi\ns hey, small fry! any questions|about the story so far?\n> questions\nl monster\ns isn't that always the point of|these stories? that we're the|real monsters?\n> questions\nl putself\ns sure, why not? i figured if you|had any questions, i could help|you out!\n> questions\nl chatimmediate\ns hey, kiddo. what's the latest?|if you're stuck, i'm here to|help.\nl questions\n! chatimmediate\n? realhint||fakehint\no where|where do i go next?\nl aftergo\nl nowhere\n? realhint||fakecryo\no cryo|how do i unbury the cryo-pods?\nl aftercryo\n? map||skipmap\no howmap|how do i use this map?\nl skipmap\n? scuba||skipscuba\no howscuba|how do i scuba dive?\nl skipscuba\no saved|is my progress saved?\n? landy||nolandy\no landy|can i keep exploring after i\no cursorskip|  finish the game?\nl nolandy\no ret|seeya, dad!\nd\nl landy\ns yeah, just reset the game and|you'll be back before the|ending with all your good good|items.\n> questions\nl fakecryo\no fakego|how do i unbury the cryo-pods?\n> aftercryo\nl fakehint\no fakego|where do i go next?\n> aftergo\nl fakego\n! realhint\ns wait, sorry, i should've said|this first. remember that this|is a game where you're meant to|wander and figure things out on|your own. only ask for help if|the wandering and figuring have|stopped being fun!\no gotit|got it, got it.\nd\nl gotit\ns okay, all that said, if you've|got questions, i'm here to|help.\n> questions\nl saved\ns yeah, if you're tired and want|to continue the story tomorrow|night, i'll remember where|you've been and what you've|collected.\n> questions\nl howscuba\ns you just need to find water|that's deep enough. then you|can head right in!\n> questions\nl cryo\ns well, the cryo-pods buried|themselves because they didn't|feel safe.\no cryomore|how do i make them feel safe?\n> aftercryo\nl cryomore\ns you have to web up all the|enemies nearby!\n> questions\nl howmap\ns hold \151/x!\n> questions\nl where\n? map||nomap\n? candle||nocandle\n? boots||noboots\n? sight||nosight\n? scuba||noscuba\n? lollipop||nolollipop\n? atlas||noatlas\ns the next step is in a small|lake northeast of the starting|point.\no morelander|what do i do there?\n> nowhere\nl morelander\ns to get into lander b you need|to open as many seed cryo-pods|as you can. use the atlas to|find ones you've missed!\n> nowhere\nl nomap\ns oh, this one's important. head|northeast of the big lake.\no moremap|what will i find there?\n> nowhere\nl moremap\ns a map. it'll help you find your|way around and find new places.\n> nowhere\nl nocandle\ns you should go to the northwest|part of the cemetery.\no morecandle|what do i do there?\n> nowhere\nl morecandle\ns look underground. you'll find|an item that'll help you|explore dark places.\n> nowhere\nl noboots\ns head directly south of here and|you'll find stepping stones|leading to the middle of the|big lake.\no moreboots|what do i do there?\n> nowhere\nl moreboots\ns underneath the big lake is a|system of caves. get through|those and you'll find an item|that helps you navigate water.\n> nowhere\nl nosight\ns in the ruins on the far end of|the swamp, you'll find a way|into an underground palace.|head in there and don't give|up!\no moresight|what do i do there?\n> nowhere\nl moresight\ns you may have noticed invisible|things scattered around the|world. the palace is their|origin. it's also where you'll|find an item to help you see|them.\n> nowhere\nl noscuba\ns past the swamp you'll find a|snowfield full of the crawling|hands from the palace.\no morescuba|what do i do there?\n> nowhere\nl morescuba\ns you'll have to web up all the|hands to get through the dead|end. then you'll find an item|that helps you swim underwater.\no nowebs|what if i need more webs?\n> nowhere\nl nowebs\ns just keep exploring! they're|hidden all sorts of places.\n> nowhere\nl nolollipop\ns there are ruins in the|southeast corner of this land,|overrun by jungle. find them,|then find a way underground.\no morelollipop|how do i get to the jungle?\n> nowhere\nl morelollipop\ns one way is to swim in the|ocean. another way is a hidden|path near where you landed.\n> nowhere\nl noatlas\ns in the zombie ruins to the|east, you might've seen a book|surrounded by invisible walls.|now you can break them down.\no moreatlas|what does the book do?\n> nowhere\nl moreatlas\ns it'll reveal new points of|interest on your map. (if|you've already found all the|points of interest, it does|nothing.)\n> nowhere\nl ret\nr\n"
,"\n")

__gfx__
00000000000400000000000000006005040040001111111156666665055555100000000000000000000770003000003000003bb0009900000000000066666665
00000000000040000000000006506056024040441111dd11567566655555555106666660066666600007700030000030000bbb3b009a900000bb1bb167567565
0000000009f9f9f0000000000560656500244420111d11d11566666551111151688668866bb66bb6007777003300433000bbb3bb0009800000bb1bb166666665
000000009f99f9940770077056656650440420441111111111566665555555516226622663366336009999000309f90003bb3bb300fff0d000bb1bb166666665
000000009f99f9940000000065565500024444201111111111156755511111516665166666651666099999900339f9300bb3bbb000ffed0d00bb1bb166666665
004444409f99f99407070700556565660004200011dd11111111566555555551666666666666666609999990003000330b3bbb0000ffed0d3bbb3bb167567565
444444119f99f9940070707006505650000420001d11d111111115655111115105555550055555500aaaaaa033000003bbbb3000ddddddd5bbbb3bb166666665
0111110009f9f940000000000000056000042000111111111111115555555551066666600666666000aaaa0030000003b0000000055555504444244155555555
0000000000080009040000400400004033333333550055001111111166666665066666600666666000566500000055000000050000000000000550006d5555d6
00000000008080a004000040040000403333bb33551555511ddd111166667565688668866bb66bb6661616560005555500005050000500000566665065d66d56
000000000a080a090444444004444440333b33b3111555511d551111666666516226622663366336566666660055555000050500000500000628826065666656
0000000090a08090040000400400004033333333055011101111ddd166666511666516666665166606666665004444400040404000ffe0d05687086565666656
000000000a080a09045555400400004033333333055505501111d55167565111666666666666666605666500555555550505050500ffed0d5680086565666656
0000000040a08090544444450444444033bb333355515550111111116665111105656560056565600066665003b1b22000b0b02000ffed0d0628826065666656
000000000909090052555525040000403b33b3335551555111ddd11166511111065656500656565000566665bbb1b2220b010202ddddddd50566665065666656
00111100009090000255552004000040333333330110051111d5511155111111066666600666666000005666003bbb200030b020055555500005500065666656
00000000000000540000000077777777433333333333333301010101333133330002220000022200005665000000600000006000300000301111115555111111
00000000044505440000000076666665443434423ddd333310101010013333310000130000001300561616500006000600060000300000301111156566511111
000000000544544500000000e8888882443432423d55333301010101333331330000330000003300666666660606060606060605330033301111566566651111
000b3000005444508222222182279221242442433333ddd310101010313431110008880000888800066666666156565061565655030330001115675567565111
00035000000445007666666576799965242422433333d55301010101133133000080880000008800056665005616161656161610033333301156666566666511
00000000054544507666666576999465242424433333333310101010031044100000dc00000ddc00006666000506050605060505003000331566666566666651
000000005450544076666665766946653444444333ddd33301010101010044100000dc00004d0c40006666500005600000056005330000035675666566667565
000000004400054076666665766666653344443333d5533310101010000044100004440000000000000566600000000000000000300000035555555555555555
0404040456656650766666610000082004004000550055000555550005555550000000ff00000000766666600444444409999990777777770005500007077000
4040404067767762676666100000082000404044550555505555555053b3b3b5000000ff000000ff676666004666666509444490777777770566665002707077
040404046766766266555501000002200004440000055550511111505b3b3b35000004ff000000ff66555500444444440994949077777777063bb36000274720
404040406666666266555510eeeeeeee4404004405500000555555500555555000004fff000004ff66555500444ee444094444907777777756b70b6577042047
040404045665665266555501e676667e0044440005550550511111505565555504fffff404ffffff66555500447e8844094949907777777756b00b6502747720
404040400662662066555510e766676e000400005550555055555550565555550fffff404ffffff46655550044e882440944449077777777063bb36000042000
040404040562652061010101e66ee66e000400005550555051111150555555510f4f4ff4ff4f4f40600000004448244409499490777777770566665000042000
4040404000200200101010102ee22ee2000400000000050055555550051515100f4f04fff4f40f00000000005444444409999990777777770005500000042000
000000000000000000000000000000000000000000055000050500051111111100eee0000000000000000000000000000000000000ffeed03330333300000aa0
00000000000000000004040000d666d0000000000005500050550055111111110e7782000000000000000a00000ee000000000000ffeeddd00333330000aa70a
000000000000b300000444d0006d0d60000666000050050005050505111111110e788200000000000000a0a000ee44000000000000eeedd03333303300a4a00c
00000000000b3b000004d4d000600060000888000050050050050050111111110e88250000000000000a4aa00044445eeeee000007626220303430000a4aaccd
000000000003b000000444d0006d0d600006960005000050055055551111111100225000440404400001aa10005445eeeee4400046646022033033000aa4ccd0
00606060003000000004d4d000d666d00006660005000050550505001111111100060000044244200001101000155eeeee4440002444444203004400a44ddcd0
06060606000000000000d0d0000000000000000005000050505050501111111100060000056265200000000000115111514410000220022000004400aaccd0c0
0060606000000000000000000000000000000000005555005500055011111111000600000020020000000000000155115510000004000040000044000cccc0c0
000000000000000000000000000000000000000000000000000000000000000099900000aa105cc5000000000000150000044000000000000000000000000000
000000000000000000000000000000000000000000000000000000000000000049910000a000ccc00055555dd000155000a44400000000000000000000000000
aaaaaaaa9999999900000000000000000000000000000000777b00000000000029940000a005cc500055555dd000155000a44400000000005bb5000000000000
aaa0000000000000000000000000000000aaaa00000000070077b0000000000024441000400c5500005555ddd000015155144115000000050bbb500000000000
aaa0000000000000000000000000000000a77a00000000070077b05000000000044440000005c500000555dd00000111555111550000000b0bbbb05000000000
aaa000000000000000000000000000000aa77aa0bb0000077777b05500000000044441004001510000055550000010105555511bbb00000bb0bbb05500000000
aaa000000000000000000000000000000aa77aa0bbb000bb777bbb055000000002444400000101000000000000000100110000bbbbb000bbbb5bbb0500000000
aaa0000000000000000000000000000000aaaa00bbb33a0bbbbbb5777b00000002444410000010100000000000001010000000bbbbb33a0bbbbbb55b00000000
aaa0000000000000000000000000000000044000b3663a0bbbbb570077b0000000444440000000000000000000244444444440bbb3663a0bbbbb550bbb500000
aaa0000000000000000000000000000000aaaa0056663aa0bbbb570077b55000004444410000000000000000244444444444440056663aa0bbbb5b0bbbb55000
aaa0000000000000aaa000000004440000a44a00446663aa0bbbb77777b555000024444400000000000002299444444444444444446663aa0bbbbbb0bbb55500
aaa0000000000007aaaa000000aaa44055144115446663aaa0bbbb777bb555500024444410000000004999944444444444444444446663aaa0bbbbbb0bb55550
aaa0000000000077000aa0000aaa4004555111554446663aaa0bbbbbbb05555000044444400000000599944444444444444444444446663aaa0bbbbbbb055550
aaa00000000000740074aaaaaaa400705555511b44466663aaa05bbb00055500000444444100000015594444444444444444444444466663aaa05bbb00055500
aaa00000000007440004aaaaaaa40000110000bb444466655aaaaab0005550000002444444000000452944444444444444444444444466655aaaaab000555000
aaa00000000007444111aaaaaaaa4400000000bb4444665bbb1100005550000000024444441000004525444444444444554444444444665bbb11000055500000
aaa000000000070001111aaaaaaac500000000000000000000000000000000000000444444400000452244444444444554444444444440bbbbb1100000000000
aaa00000000074000111111aaaaccc0000000000000000000000000000000000000044444441000045225444444445554444444444440bbbbbb1110000555500
aaa00000000070000011111ccccccc0000000000000000000000000000000000000024444444000045222444444455544445555511550bbbbb51110555555500
aaa000000007400000011111ccccc10000aaa4000000000000000000000000000000244444441000452222444444444455111155115100bbb551110500055500
aaa00000000a0000005000000000000000aa44000000000000000000000000000000044444444000452222444445511111111155111110005551110500055500
aaa0000000a1105000055022200600000aa444400000000000000000000000000000044444444100452222111111111111111115111111115551110500055500
aaa000000aa1155500005dd6666600000aa444400000000000000000000000000000024444444400452222111111111111111115111111115551110500055500
aa9000000a111c55000005dd6660100000aa44000000000000000000000000000000024444444410442222111111111111111111111111115551110500055500
f1f75dff94e83efec1dfbb754eb8ff1c1fbbfdb78d917e91fef717c917f95d3ba765fc3c57ebff5c176c9dcff8fc6529f92298db9442376229a5267c9e7f3e97
ef7cfd4ef70936f77e8efdd3af77e7dc71ff383ef1f36f4b33ec332fb5cbff398e91fdf117ef517fff42e79ff944fc83a1767e84cbf6c198be8f1ddf37c57c3f
cff8fba3e83e7dc17efd9fae7b6cd7cff0c7dcfe9e4f7b8dff42e7b33ed3ba765fcafbfcafa784e0fbef4193e71fefc1b3e97ef7cf5f7c83efec1b767c1f5ef7
d1ffeff0e832274ff7093eefd3dc17eff0674df0d9d917e91fd97cf717df61ffbc33eaff354b7a729f92e9f9293e8467cf0e7a3ee7ef7cf5e7c3ce8cfa932fc1
7c5ef7e7c3d3f7f6b7cc7d9d917e91f7f95d3ba765fc3cf2764ec8c91f4fc4ed4e074a6983f8fdde7e87e8bf9ff9cf879c17e3d3afb6e8efd5ff3effb4ce87a1
75b7c1e9e167e4ec93f7b83ef88cffa2ecfd6edf32efd33afb5c1d84f94431f3f1f7afef7093ea7ef72f5e7cefa9f17a7c7f77cff2e875ff7517437c5e9ecfb7
6cb765fcae99ff2eafbe4fd917c9def0e7a4c17cfcff3cc17abf7e8d17e39ff95e9ff1d79f13fb6e7cb4f87ffecfa9f2ef7a7cbda3b93e67ffed6ffb8f5fc8c9
79c91b33eafb2ea3ff9ff34ec5f394e7a8b27a42e83ef4f3c17f3ff3cf2f3e7ea3ecfaef74744f8fa7cfff1c437c3edeefb8ff1e9593ba765fcaefe75f7bff74
af393fd852ec4cef70b3ef67d1fc3ff34bf1f747f75ff3c3ef74ede17ebe83faff34fc7cf1dff9862efc3efdfb77c3fcff0fb8be7cf1c9f5dff0e8ff1b7a7e9f
a3ecbeff0d3faffaef8efefbfafa62efc3efdfbb7c3ff3bf1f9f5eb8effc3ecf1f74df6e7bfd3ee3ecfbf69ee8cff0a74efec1fabb7e91ff3bf32e7e6cbd7ef7
c74f5dc421b73ec4c97cf7f77f8f3f9f9fb8dfa17df8f3ac79ff57dfb7c1f7f574d9ddfff1ccfd93e37efe74376c976cf876c176e7b8bfcac9593b2ff3fba1d3
f6dff1fdfff8cff87d7d3ffb88b317c1ffdfd7c1f7c3f3b7e7d8ef87efa9f1f3ffefd7e177b2ffba84f83e70f63ec33276cbfb54ec83ec87ecac9593b2fbd5e7
ce3ff3e67ad34ff717fff53af35c374ef70936ff3cc1fbabf8f3e9f54f7d8fe7cf9dfbf7fe8fa1b6f8f9cbd8cf61d33676c776c176cff0ecbda7fff83daf327b
3f8f3c5f374f8cff0ec3e787e79f2e79f1f78f2efeffb44ef7093e7ae17cfce96db76c376efbc91d33ff5ec8bfcac9593be7affb4c5d7dbf62194ed8f9ff711b
3e7dff16e88f5f8fe9f5f7cafde7cefa9f1f8faefb3ef8fb37cf0eeeec87fc8d91fbdf193b2765ecef11fe97b6feff17cf5ffb87fffa1d3ef07cfc1f3c1fe3fb
e79f1f2fbc79f1fcf2e7b6cd7cfef77f8f1c5d34ec83fc8d9193be7933ef7cdfcfeffb88f1e7a8c1fb9f5f87f9fd4f7cb4ebaf1eb83ebaf7f8f1efee17efdd3e
74763fb7a3d336764ec8d93f3f95d3b2765ecef11753a7edadf427cb17426f35cff0f8bc7f37c97cbfcfeaf36f7dcf87c779f1fbaffe875ffebf8f9cdd9d9193
3af74c776c176c3765ecac95757ede7a987f7a84e09ffb6c27abf7a842ee3a6f35cf47cbfcf1eaf17fdde78fae7b6cd7cb67cf1eee4f7b8c91ffbfef3e7a4c21
bf929a52e8c42d73e794c37cbfcf9ebfe17f778fda17dff027cb2ff7b8c19ff14f8f5d5d3cff2e7b87ec6ff1772f6431752e84cb983e7aadb9443d739a46ee32
ff383f8d3f7e75fe7f78fda17f1f8bf8f5c5fb7ab3ff47c9f75ff17cb1f4e6feb1742ef7974f9f3fb97e7cd7fb9f5b1fc1f8bf8f5cddf7c1dff3affed8ff9eb1
7efc17f197efcfe07ef87d7fbdfe9efaee3aff38c179be8bc574ef7093aeeef3e8eff1dff931762e78f93ea32f4ef76d7e7ffdbf5ff7d9f2af3e7fdf2dfdcb7c
5ec3e2fe1575ff175f72bef0ece3f625f62a9a4e0dff54c21b4c198f2394cdf37c77c9fcf9fb7b9faf36f7dcf8f7c774fac9dbcb7c52ffba8e17bcfff9983ef7
51d32e9ef5a764fc83afaeffa2adbdbdbc1983e7a86aa98b2174e2742a9a42e794c77c5fcfddc77cf8f3efa9f17fb6e7cefa9f13f5b7adf5176f0fc17bd1f87e
8af13fcb9ca1f7ef51ff5f0bf92985e4bc929acff22ea4c997c1f35c1f62194d5f37ce8be9f7ebf9f7cf1fb4f2d44ed4a6dafe8fdd97c1e7ee3ed32ef767cc1d
cfe96d198f3ff711feff22efaff974fd87e8cff027c1fcfbfb7eb3b7f7df13ffbfcf8fc7de9276c998f5e8ff18f921d6c9da42ec36af74cff0f8befe85becff5
cf42ffb8ff183fa93e7a8f9e8dffc2fcf7df5f7c7a7dff426f6cf97cf7e7c65fd8f5e83dff0e8bffea6bff39acffc398f9e7a8f5ff711f3f59fff3b9b2ecf93e
7c3e87efbefaf3e3ddfe3d33ec4cf67cf3e7a6ed43e8ffb4cf87c9ef7074ef7093eafbbd9df4944ed4e07fb9c3ec739a46e8f92eab6ee4c1f37c17c9fcf7df1e
e3e7c7febc59eb1fbd1f79f5a3756ee3e4f7ef517df1d3eafb3d3425944f8efd1f34e0d4c79af527a7f83f9ffabbf72df1f0bb3ffb9ddd64ec87b5f3f1fbaf5b
7b7217ef11b32ea6df0dbc17cdd3cd74ffe8cf4194cf5f35c21ff3a3ee7ef9eeef9df477b5d44eff4174f0ff7aed94f2d4cf2dbc3db5f8bb79be8efd1b4c1983
f7a862e845217df4175f7ef9fa3ea7efee17ffcba377dd9e92f754319ef0ef7dd33f35b2ff3987af383e7f6f9ff14e8bb7933f833194d198679bb176f7bf9f7a
7efce17ff4bf9fe4fec1df9dafb8f9bf36aa9a6f0f4f7475fd3eeede7c6535d442b732fb7bff3df9f797e7fe97ff0ffb9ee7ab3dfffb5ecfd3df9c5d7f8be7f4
ff694df0dff9efcfbe3fb9fd7f3ed9ffdceef3bfff74c5df9c9d7f87af7b4ae78ff3fe7eff3bff5c6f62fcbd4fefbbff7bddd3c5df9c1d7f87bfbcfb9ee7f962
e7ef9f757cfcff9ff5ce8f1abcf0dd99ed7ea7ff1dfb675f7adfcda3af39babfd3d3e87a7dfb7fff3375ef7c9f7f6973a9a3217dfc17dff42e79f9ff6ffb8d1f
34ef759f12bb39b3bfbee3af3eefee5f766fba3bf38f1a7c1f6fabaff6ef7a9f737def7c59ff55efd3c198622f621dee7e8ffe7e3df0f3f1ef7e7767cf07c6ff
7962776fef0ddfc77bfde7fff166fbcd9df8ecebe7ceef70d3ede575efdd5df77affe1ee4c1d34fd4e2d4fd6e2dc1f3737a6e49f9f0ff3fdf49cddd3fffacf09
dfa77afeef76f3467ed9df0e8ede8e96dcfe9e174e9be86f8ff76efdeff33ff6eaefb9baff3dc59f7f4b4525bfdbd9bef88f3f7e8bff7e17ffc3ff3fd19cb9c3
f63fef09cf8f667cd96eeb7f3dd9ddf347fef0ddf6e8e56dbd1d3ef76d7ecff95e7f6f8ff96facfb7eff33ffed6f355f7a8426d93e7a8f5e7a8df41fdf117eb1
df9bef7ebff3ed7f6776df1abf9f78367df05df12bbbdd3e8e9af74a7b3ab36fffecff82fff702ff3acff7e8e575efdc57efbdbec62fa57a983f7b872577aec4
4237dfc5ff3fdfbf346db3b7ef789dd7f9bfbf78367ff019ff944e78dec6d1f74465763fb7a574f47477c1ff3a7a7d57ffbdb2ffea5f34f0f3cf41762af354f7
a852ec4ded83e7e9ff9fe7ab7bff7dff03bef0bdbaf3c1bcf995bbfb2e7e6df0f74a7e1d72ff3abb7d59f7fcb2ff6eadfbde1ede9ecfd2e784cb98f5e7e9ff9f
efcff166fffcf1ab3eeee8f1abba78f9efa67e78e5f4ff747e39e57db6ff6a7a7a7dff932983f7a87ff7e19c3edfbae8f93ff7eaff9f2776ff3db3b32fcbddfc
7f6f3ed7ce78e56da3ef721de1ebebfffdcff86fffb4faf7f3f35f78ff37e7e8f121bf92e7e73f744ffaa62ef7db7e7837ffbbf12bbeeb6fdd7daf34776f75de
deeeff4efd3bf7dfc78b35fff7c7fdf075ea53fcefcf1abddfde9bf95e78ceceff0cddfffdfcd4e7ea6ef6fdb1ffbedbf3c1b5ea537dbddd776fbddfde9bf9dd
dff18bbfffdf9b9efc5dc1f63fbaffbdeeff16e7836ff7abf78dd7fdb7b7fe78e3e96e7f6fff1f374ed8f9ff88f331ffbbb3bbf78ceffa7fbb7eeb7bf12bbb7e
6f346f63fbf1daf1af95ff7de7cfb6edfd2e9c5a98ff5fd9d52f347df12bfe78d67f6fed95efcce7abf9d77f9bf1bdde7836df33bfa787b7bf1bf8f5af8df51f
ff79eecf09fd22b9cff42f3469f1abdd9d9f3c1bff1dff03b3fecff6a777fbdf09df4f3c9bf9a78befa6f47dffc3e7bfd2edfd2ec6e7f3df8f7d4f7b8f721ffb
e54f78c66b339df29cecff1669f12bb39de78ce78b7b3fece7fff1667ff0db3bf1b7abb7abf7b8ff1e13bf3e2bfb2e7bfb2f62f3a4e2bf93ef7ef346db3bdf0b
5e78cff03b4abdf99d79eeef12bb2dde78eebb7bff9fd7e6f76674fafb2ece5ef717c9e7cfd2ff3dc519b2ff3d83ffa8ffe7a8efc5ffb8fd2f346bc9f342d7bb
b37fbdcdf3437ebd5fff59f1ab7fe37f3ef0bdf27f3bba79bb7af3eff81fbc179ba9f93ebff97cbf74df4f35c5f3fcff2f78ce9f12b7f78cef7cf3c6bff166bb
3ffb9cd7ee9f1eedf27fdf34674f677f4ff3efd3d8d1f83adf93eaff55ce7b862e78ff94cfaf3fcffcff739df1f346f3df99d1f346f3ef99f1ab7ee37f3df0dd
eeef09dd7769bf8ffd4ce78cad7c5dbce7b83ef77174bedffd54ef7e1b6ce8dff037cdddfc1fc51b4dd98f1e7a8ef417efc3ffb8dfef3477ef99ddf3c1bf1f78
36fed7daf347f3dd9f16ff3cce9f1e09ff554e78cadbdddbcf4daf1e7b853aff383e8bb78667d99f9cfaf354e7e3dff2eeceaf1abfdfece8f1abbff789d19c6f
3c9bbeeb79f12fffacf0ddf0ffb9ef0dbbbbf78ef99f1a774f78c2fbf1d3cddcfed6dfcd3ce7b87a57d1dff16e85f8f9bef79f3f7ef717f9b3f78eebb3bfb3dd
1f3c6feddffd4eee6f347f3dff6a777fcf0bb7f34675f0f5bebf32adbc1f74ca793f8bbdf97ef74f3ff6ef7e7f5b3e78339dfdf62feebb3b7eedaf3c6f3fddd7
7f1bbb3f34bedeff8e8f9dff0effcdf9f75ff3bbfed39eef9cbbfeece9b7bcf0bdf2777fdd7ceae1ebecbdff1e1fb9fffb8fb7a7cddc9b4e8df29c2f346ff3bb
f8dfe776f3cd7ceae9ed6e7f3cbf744af79e1f7bf5f8bcffdbbfd3dee9477ef0d5eecec4f7837ff39b7bfdeece7cbf8d9d3de8cfdd32efc6e7f637c1eee9aff3
cc1d727cef7893adeff9b7cfaec3e9f93effddeaf3c1bf3f788df09db7f6dbf8d57767edddf677ef729f12b7eeca7f1b3a9fdf0b36f77e8eff02ebff94c7ff38
eff037c4ef721767a7ce93e8dfe9e1f37e9e1ffdfc5fff8ffb54bd5f78377ef07cedf1a2ffba8cff52b7eef16ff3cf33bcd9f16beff03bbfe37f632ff38effb3
ff3a8cff82fff9af7e83cddcfe5b36fce83a7cfc97ec3efaf97eff5dd2f34776abef0dff75e78ce94f78aef09d97ff2beff03bff1cf07cebb7beff03bbb1bff1
5cef74d32e7cffd5cb74e9c13dffd5cb7c1f4e896f8f93fcfe7c5f4e7e3cffdf7fcff32d369f33bdf0d52dd5f76677abcf07ce8ffd4eef57f7edddffca5bff15
4efffc54ef74d32edfd2e7c7674df47cd2dcfe96f7ec3ff3af9beff9d36f4abeff03bbef789d19eea46bbff8dfbff3cce8f33bf3b3d32ff3a8dff8a74c1d8fde
9d157cff92ed3e49fd2ade3ff35fffce2fbcf0dcf6bddf7eef7bf7667cf99da78c1dfff6ef74bfff5e8a57eefd2ecee8c3936ff7c8fbb9f93fcff4dff3ef7c7d
ef717ff3bff37f4d3e6be1e7cee83dbd9be7b83adff95f9ff98ff74fedffceeff67cdfcefcb7b7a7bd1785f4f3477c5e9e5af74c1dbe9ff98ff74fbbfadee77f
edff7bdeef1777f177feff17a1f4fc3aff3cc117cf11def8adbf9ff98ffb7f7cbffff97f7eff1fbdff3f3ff35ff7befc7ffff3defff9e7ef76ef760000000000
__label__
90909900099000009090099090900000999099909990999099909990999099900000909090909990999099900000909099900000909099909990999099900000
91919190909100009191909191910000919191119991911199919191911191910000919191919111919191110000919191110000919191119191911101910000
01019191919100009991919191910000990199009191990091919901990099010000919199919900990199000000919199000000919199009901990009910000
00009191919100000191919191910000919091109191911091919190911091900000999191919110919091100000999191100000999191109190911000110000
00009991990100009991990109910000919199909191999091919991999091910000999191919990919199900000999199900000999199909191999009000000
00000111011000000111011000110000010101110101011101010111011101010000011101010111010101110000011101110000011101110101011100100000
99000990000090900990909000009090999099009990000099900990000090909990999099900000099009909990990009900000099099900000000000000000
91909091000091919091919100009191919191900911000009119091000091919111911191910000901190910911919090110000909191910000000000000000
91919191000099919191919100009191999191910910000009109191000099019900990099910000910091910910919191000000919199010000000000000000
91919191000001919191919100009991919191910910000009109191000091909110911091110000919091910910919191900000919191900000000000000000
99919901000099919901099100009991919191910910000009109901000091919990999091000000999199019990919199910000990191910000000000000000
01110110000001110110001100000111010101010010000000100110000001010111011101000000011101100111010101110000011001010000000000000000
09909990999099909990000009909090999099909990909000000000000000000000000000000000000000000000000000000000000000000000000000000000
90110911919191910911000090919191911191910191919100000000000000000000000000000000000000000000000000000000000000000000000000000000
99900910999199010910000091919191990099010991010100000000000000000000000000000000000000000000000000000000000000000000000000000000
01910910919191900910000091919991911091900011000000000000000000000000000000000000000000000000000000000000000000000000000000000000
99010910919191910910000099010911999091910900000000000000000000000000000000000000000000000000000000000000000000000000000000000000
01100010010101010010000001100010011101010010000000000000000000000000000000000000000000000000000000000000000000000000000000000000
00000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000
00000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000
00000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000
00000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000
00000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000
00000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000
00000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000
00000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000
00000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000
00000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000
00000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000
00000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000
00000000000000000000000000000000aaaaaaaa9999999900000000000000000000000000000000000000000000000000000000000000000000000000000000
00000000000000000000000000000000aaa000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000
00000000000000000000000000000000aaa000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000
00000000000000000000000000000000aaa000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000
00000000000000000000000000000000aaa000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000
00000000000000000000000000000000aaa000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000
00000000000000000000000000000000aaa000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000
00000000000000000000000000000000aaa000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000
00000000000000000000000000000000aaa0000000000000aaa00000000444000000000000000000000000000000000000000000000000000000000000000000
00000000000000000000000000000000aaa0000000000007aaaa000000aaa4400000000000000000000000000000000000000000000000000000000000000000
00000000000000000000000000000000aaa0000000000077000aa0000aaa40040000000000000000000000000000000000000000000000000000000000000000
00000000000000000000000000000000aaa00000000000740074aaaaaaa400700000000000000000000000000000000000000000000000000000000000000000
00000000000000000000000000000000aaa00000000007440004aaaaaaa400000000000000000000000000000000000000000000000000000000000000000000
00000000000000000000000000000000aaa00000000007444111aaaaaaaa44000000000000000000000000000000000000000000000000000000000000000000
00000000000000000000000000000000aaa000000000070001111aaaaaaac5000000000000000000000000000000000000000000000000000000000000000000
00000000000000000000000000000000aaa00000000074000111111aaaaccc000000000000000000000000000000000000000000000000000000000000000000
00000000000000000000000000000000aaa00000000070000011111ccccccc000000000000000000000000000000000000000000000000000000000000000000
00000000000000000000000000000000aaa000000007400000011111ccccc10000aaaa0000000000000000000000000000000000000000000000000000000000
00000000000000000000000000000000aaa00000000a0000005000000000000000a77a0000000000000000000000000000000000000000000000000000000000
00000000000000000000000000000000aaa0000000a1105000055022200600000aa77aa000000000000000000000000000000000000000000000000000000000
00000000000000000000000000000000aaa000000aa1155500005dd6666600000aa77aa000000000000000000000000000000000000000000000000000000000
00000000000000000000000000000000aa9000000a111c55000005dd6660100000aaaa0000000000000000000000000000000000000000000000000000000000
0000000000000000000000000000000099900000aa105cc500000000000015000004400000000000000000000000000000000000000000000000000000000000
0000000000000000000000000000000049910000a000ccc00055555dd000155000aaaa0000000000000000000000000000000000000000000000000000000000
0000000000000000000000000000000029940000a005cc500055555dd000155000a44a0000000000777b00000000000000000000000000000000000000000000
0000000000000000000000000000000024441000400c5500005555ddd000015155144115000000070077b0000000000000000000000000000000000000000000
00000000000000000000000000000000044440000005c500000555dd0000011155511155000000070077b0500000000000000000000000000000000000000000
00000000000000000000000000000000044441004001510000055550000010105555511bbb0000077777b0550000000000000000000000000000000000000000
0000000000000000000000000000000002444400000101000000000000000100110000bbbbb000bb777bbb055000000000000000000000000000000000000000
0000000000000000000000000000000002444410000010100000000000001010000000bbbbb33a0bbbbbb5777b00000000000000000000000000000000000000
0000000000000000000000000000000000444440000000000000000000244444444440bbb3663a0bbbbb570077b0000000000000000000000000000000000000
00000000000000000000000000000000004444410000000000000000244444444444440056663aa0bbbb570077b5500000000000000000000000000000000000
000000000000000000000000000000000024444400000000000002299444444444444444446663aa0bbbb77777b5550000000000000000000000000000000000
000000000000000000000000000000000024444410000000004999944444444444444444446663aaa0bbbb777bb5555000000000000000000000000000000000
0000000000000000000000000000000000044444400000000599944444444444444444444446663aaa0bbbbbbb05555000000000000000000000000000000000
00000000000000000000000000000000000444444100000015594444444444444444444444466663aaa05bbb0005550000000000000000000000000000000000
000000000000000000000000000000000002444444000000452944444444444444444444444466655aaaaab00055500000000000000000000000000000000000
0000000000000000000000000000000000024444441000004525444444444444554444444444665bbb1100005550000000000000000000000000000000000000
000000000000000000000000000000000000444444400000452244444444444554444444444440bbbbb110000000000000000000000000000000000000000000
00000000000000000000000000000000000044444441000045225444444445554444444444440bbbbbb111000055550000000000000000000000000000000000
00000000000000000000000000000000000024444444000045222444444455544445555511550bbbbb5111055555550000000000000000000000000000000000
000000000000000000000000000000000000244444441000452222444444444455111155115100bbb55111050005550000000000000000000000000000000000
00000000000000000000000000000000000004444444400045222244444551111111115511111000555111050005550000000000000000000000000000000000
00000000000000000000000000000000000004444444410045222211111111111111111511111111555111050005550000000000000000000000000000000000
00000000000000000000000000000000000002444444440045222211111111111111111511111111555111050005550000000000000000000000000000000000
00000000000000000000000000000000000002444444441044222211111111111111111111111111555111050005550000000000000000000000000000000000
00000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000
00000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000
00000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000
00000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000
00000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000
00000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000
00000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000
00000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000
00000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000
00000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000
00000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000
00000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000
90900990999000009990909099900000999099909990099090900000909099909090099000009990099000009990099090909990000099909090999000000000
91919011911100000911919191110000919191919191909191910000919191119191901100000911909100009991909191919111000009119191911100000000
91919990990000000910999199000000999199019901919191910000990199009991999000000910919100009191919191919900000009109991990000000000
91910191911000000910919191100000919191909190919199910000919091100191019100000910919100009191919199919110000009109191911000000000
09919901999000000910919199900000919191919191990199910000919199909991990100000910990100009191990109119990000009109191999000000000
00110110011100000010010101110000010101010101011001110000010101110111011000000010011000000101011000100111000000100101011100000000
09909090999009900990999000009990990099000000099999000090999000009990099000000990909009900990099099900000000000000000000000000000
90119191919190119091919100009191919091900000991119900901019100000911909100009011919190919091901191110000000000000000000000000000
91009191990199909191990100009991919191910000991909910910090100000910919100009100999191919191999099000000000000000000000000000000
91009191919001919191919000009191919191910000991019910910901000000910919100009100919191919191019191100000000000000000000000000000
09900991919199019901919100009191919199910000099999119010999000000910990100000990919199019901990199900900000000000000000000000000
00110011010101100110010100000101010101110000001111100100011100000010011000000011010101100110011001110010000000000000000000000000
00000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000
00000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000
00000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000
00000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000
00000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000
00000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000
00000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000
00000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000
00000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000
00000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000
00000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000
00000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000
90000000999000009090999099009990000099900990000090909990999099900000099009909990990009900900000000000000000000000000000000000000
99000000091100009191919191900911000009119091000091919111911191910000901190910911919090110910000000000000000000000000000000000000
99900000091000009191999191910910000009109191000099019900990099910000910091910910919191000910000000000000000000000000000000000000
99110000091000009991919191910910000009109191000091909110911091110000919091910910919191900010000000000000000000000000000000000000
91100000999000009991919191910910000009109901000091919990999091000000999199019990919199910900000000000000000000000000000000000000
01000000011100000111010101010010000000100110000001010111011101000000011101100111010101110010000000000000000000000000000000000000
00000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000
00000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000
00000000099099909990999099900000099090909990999009000000000000000000000000000000000000000000000000000000000000000000000000000000
00000000901109119191919109110000909191919111919109100000000000000000000000000000000000000000000000000000000000000000000000000000
00000000999009109991990109100000919191919900990109100000000000000000000000000000000000000000000000000000000000000000000000000000
00000000019109109191919009100000919199919110919000100000000000000000000000000000000000000000000000000000000000000000000000000000
00000000990109109191919109100000990109119990919109000000000000000000000000000000000000000000000000000000000000000000000000000000
00000000011000100101010100100000011000100111010100100000000000000000000000000000000000000000000000000000000000000000000000000000
00000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000
00000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000

__gff__
0800000001020101000000000000000100000000020118010000000000000001000000000118040100000000000801010001010008080800000008000008000100000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000
0000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000
__map__
0d3c0f3d504d4c4e4a381e033457201807302f6676753b0b712468043f377e1f4f65801314311267722235102c46483673170a1c09451b393328293e264056272532080615051600feffbfe24dfeffe81b5f7ef5ffff1f4ffc9cf9ffffe3ff65fcfec4af897f73fbfffff527ffb3f825f5777a9da95ff2fa25a7ffffef49fdf9
26b96a579337de5ceefc66d953ffffdf7cce127ffd4f7345ffff50f49a37b13fe27ff6d49f6fb237feff3ff3ccff1fce194bfc8faf7ade247efe3fc6df4ffcff7fd3397d93f81f5ff5cbff317ef9357e79e2efff65fcff7ffc13ffdbabceab89ffcb53ffff5ffad4ff26bd6a5753ffe5fc35eedc4ffdff7fe953bf25fe4eafca
d5d41f792c8723f5ffff354ffd92c33fc91b7b93f83d73ffefe2cce5ffff6b9ff839f3ff7893f8ff9f89ff3f975ffd9f13fffff14dee37b9defaff33b9fd7f53ff7f2cf71bffff2ffb298e1cfe5f89ffff92e38dbdc97c6f72be49dfb8f38bff61ea4bfd3f52ffff1f90f82ff3530eff267e4cfc6ffe97f143e2ffbfe4f0247e
7c93bcd1ff635ca99f7e8a23f16fe2c7d4ff36f1bc49fcff91dc6ffc9f134bdea49af83375fe143fa5fef99fc5fd539ca9ff454e3ffe1affffe94d0e4feacfc4f153fc9afa5fa7feaf7fc5ffff4c24b53739fe4df246ff8ff5249afaf5a73853ffebd4ffe7affaff776fe4df68e2cfdcfefcdfc552476eef53cf4f71a5feefbf
c691f8ff0fa92492d89bf48dfff9ff31de5ccec4f7d42f89ff77eaff3f26f66fbcffbb686279dd3fc5bf89fc2f23891f9ef929f5ff4afcffdb4452c929892ba71f72b873b8f293fd1b67e27eeafd2996f87f25feff43e2fc3796f8123fe6d53c7ec80f9e277e4adef87fbc49fcffeb9c6f52c9ad79fdff9127ffb3f8ff25feff
572ae91bffff1f9bfaff3389ffff4f4bfdcff3b8ffaa9fdee4d737f9e98dbec9cffe7d93f78dffff9cfa1fe7f04be27ff1575c7fc4ffff57fc144bfc8f52bfa5fe67bfc5afff7f24fe7f89fe1fe3ff9fa7fe7b93fa35f3eb6ff13ff82dfe4efc0ffe77f163eaff1ffd144fe2ff98fa7fe40f7f26ded49df8ff37a9ff793eff7f
f54d7ed437d91b4b2ca7fdefa289ff7f96fa9fa6feff6b4ed79b1cfeffca133ffd1447e27f9af85fbcf5fffd5fc6ff7ffb9fe589df9337fe4e9e389ea4fe2fffcbf8ffff869fe2f829fe87cfe57ff257fcffc5c4ef89ffffeffb2bee3fea7f9c5f2dbffaffffaebcfeffbf29f5ff97f2faffffe6c4ff5ffd23feffbff1a73853
ff7ff0aff8ffffe9c4ff5ff85fc6fffff726feffff1fe0a7d84fd13789ffffff5749bc7fc412ffff7ff75773bec961f9def8ffff8a9fe2ffafff15fb2bce3fe2ffff2b7e8a3b79e3ffffffff01fd14ff7ff2aff8f18ff8ffffee9fe2ffffffa19337feff6c7ef5ffffcf6ff2c71bffd737b9dff8ffe4f6ffffb1ffd6ffbfc9cf
ce9cfe074ffdf253fcfff9ff653cbfc5decaff32fedfffcbf83fa5f63f8fdf13ffc327fefff55ff3ffaf52c79fd15fe397d47fffb33cf1db4ff1ff27ff68e2fa23feffd39bc4fe27f1e30e67e27ff753fcffb9fce04bec9ffcb27fe2ff1ffc193fed72246ffcffc7dfe2ffaffc9fe2ff0f2e7f66fd33abfc1affff1f9378ff6f
f17f4ffc7f76fbffff88bfe248ff8833b55fe27f9bd7ff2671fccfe3de0ffec74f7d3fc5f153fcffd1fccf7ec93f917ff24bfcff9d3789e3d7d87efc33ab23f1df137f26feff7f64bfda9bc47f4ffcfc531ca9ffff1fd9eeeca75fe37f94f92df1ffff233f64b9cffde07f9acb0f6f12ffff3fb4e33eb71fb6d3ff2a79e3ff6f
fc1af9e5945fe3ff3fffb0e53ed71fce1dfeffc23ff965ffc4ffeed7c82fb55f2abfc6ffdffe2dce37d99bec8d266f1ccb0f5def633ff8ff3fbf467ea9feffd1e82f955fe3ffcf3f87f7b7f873f7ddfde0fffc53fc8fff97f1df3ff9e5c77f62bfd4fd4bfdffd9e7d067c91bfb2deeff53ec7f19effed25472fbff13bfc4fff6
97ea15bba2bfd4ff9f7ef3c43f896fbfdedb2c73e6f0ff077fc93f917ff24bfc4fafe89fb17ff24b1cd71cbfd4f74bfcffb9dfeacae9d9feccbeff69aefd4ff3bfc9eafd358ec4ff3cf1ffbbe2b8e2f9339e3f23bffce8ff4f257e482cf1ecfda13b9cab73873379e3bf9fe24cfdff812b8e2b7effbfc78fbfc4ff1ffc7fe77f
94ff3f90ff51fe3f913789fd1677228924ce4477fe99bdf27f8b6db6dbff20f1a4fe3f57f4cfc815c715bffdf2b3ff3ff83f8afd8fe2f92deec4127d93c8be1fb2d3aeee67ffbe491c3fc512ffbf2b8e2bf2679cbf5cf64f7e39fdffb9ff51ec7f143fe6756e7f66fd337bae6b3ffcd0c5ff22f1ff47ffeff1fd9a5fe2f835fe
ff5caaffa3d8ff2892387eabdff7dddd7367fbdf74f70f59fc0f7f8a33f5ff47ffefb55f1eff7f25fbffe67fb4ff5f527f25baef3ef6e3dd3dfe6789ffef2f97fddfe3e75fe2ff2fe576fd16f92df25bdcbf45df24baefbef6dddde37ffa26f1ff877f89fdf2abff7ffa5bfdb0e3876ef7b3f7de6eff7fee9ffcf2d33f71ff12
fb25feff708e37feffc0defbd9731fbbfdffa52b7245fea7f1fc72d92fa7ff6f2affa7f8ff43bb7ee87a9f7bef73b7ff69f2c6ffe897f8e17f1ab9e2fc9f46fea771fc123ffe12fbe5c77fe27f93daff1fabff3fb8eb87eca73fb3ddc76effc77ff2cbf74f7fb9e497eb9f387ecd15f99fc6fdcb617fc6f3cbe9ff9efaffe37b
7fe8fef54ff2c67e8a5f7e8d9f7f8d5fffe7952b9e2bf24b3cffc4f767f47f1effbbd4ff9fd8cf7f66f79ff9e1d8edff7ec573c57dc5fb3fcdafd55f73c5f34be497cb2f7fc6ff3675ff15ffefe48d63df0fd9dffee7895fafe815f715bd62571cbfe68af37f1afdb58e2bf24b7cffe497fd13ff973789fbaffaff037fc6b5bf
3d7fd6ff28f5d315f93572457f9d5ef1fb955f2b57ec9ffc72fc13fd33feff74e2ff0fff19ffa33fe34cfc0fdf247ebee2b8e2bd6257dc57e48af38aef97cb73bdfe4fd91bff9fd4fd67fcf4bf8c5f53ffa76b7a457f89fb8af78a5d912b72c56fbfc4ffff4dfcaf537f27f253fc7ed571457fa9e77f1ef7afb95eb9e2873fa3
57fcfa67fc9ffe97f1ff07f2a7e40767eaef37893379e3f72b7ac5aed815fd3572c5cf57ec97f8e18afd12bffc12ffa7c4ff5fccbcb9fd8f7e8a3faf78af38ae387e89fc72eb3ff9e574fcf2a3fd32fde5f1bfc80ffeff3ff597bfddbfc4fff897e82ff1ffff1d895f7ff9eb9fb87f89f79ffcf2f33fd17ff24bf597eb9ff8ff
77cfe9ff93b852bf5ff1d73ff9e5d45fce7fe2ffff43f33eb1a7ffb338d3e7f0bfcae57c93f8fd8afb8a7f7f8ddfaffafe8cff7f98c79f89e339fccf523f247eb9a2571cffd47d45aeb9fea7d12b7645fea7f1eb15fffffa49e67f98b89f9ff53952572eff835fe3bce2ba26d7ec8a9fae78fe97b12b8e2bfefff5ff2c4ffc8f
df24fe7c0e47e2c8fcf85335f1cb15b9a257e48aeb8afe1afd357eb82657fc70c571c57d9d7a1dfeffcb13ff8b5cf653fc94fae38afbd778afb87f8d5faf38aef8fffff0a7fe2f3fc593f9e37f9e2b7ef89fe6aa5cfd9fc6f14becbabc571c573cbfc4ff7fcafb1cfef73fc54fa9bf7e8d5c912bae2bde5f0edf15d715c715d7
2f87ffff94f82d75fc14fff39fe2c8e58f2b72c5fd4be49ae3ff14eff539af38aef8fdcff8ffbb4f3d39fc9ed94ff1fd14f74ff16be67ffa6be4973aaf38aff8ed97e815ffc35fe2ff6f3fc9eb9fd499dbfd53eca7b8f2faf797ffa35f7ff9c5ffffcdedccedcbfcffa35fe2fffff3f2a3ffbffacbaffeffff1ff27fddefffaf
fa9ffdaff7fd9fffcfc7cfef33ff7ff33b7ebcbfc7f5fd5ffed7f92effcbeffcdff7c77dbf3a7f3c9cdffbf3ece893ffd9fcffcd1f7ffae6872fffebe3fbfbbf9cbffc9733dfe57ff9c5fee7fb71f2bd3f9eae1ff3bfcf8f95ff551c5ffed7f9ae9fe33c2eff7fe3cb8fbfd87f392ff7f78f5fcf7c97ffc517c7affb71ae1f3f
f78f737fe7cf71fc1c39f23fd851ff7fe37fdf1f7ff1fc1fe2fefef1e31fb1eff63fffe2fef170feeff7e37ecd8f87fbc7c3f59d7e38eaff6ffd98e3f931fffbfe38c739f92faeef9f33aeff2ae7a9bf1fcd57ffbb1f2ff78f8febc7fceffbe31c5ffed7f90e3f1cf5ffb77eccf1c38f739cf9bfe58ce7bf9c3ffdd7ef3aebcf
cefff2ff14fbb1bfe6c7c3fd6b7ebcbd3f1eceef70fefff1388ef9ff5bc79ee3387f9ce3ccff2167fcfbb5c7197f75fee7ffeb387fbc5d3fbeaeffcb7e3c1ddfe1f8ff13f9ff93b1e3f0ff377fccb1e7388e1f0fcf19e757f95fc54fbfb7c719df793a7bf8dffe78b97e3c7fcd8f87e7c7cbbef3e7b88fe389ffbff1638fefc7
39cedbf1cd6fdd59fd2d9e3fe2eee97ff3e3edfc31fffbfcf8787e7ce4bb7e8eeb389efaffdb47ff073be6f7eff05b7bceaf677bf95fffb85ff3e3e1feb1bfe6c7c3f7e32ddff573f5e7c8713cf3ff37bef8e5abf7bbe4b7f8b93d0fdf39f92f677bfb5f7c911f1fcf8fb7efc7f37b7edeff367aec39fdff8dafbeef2fbfb4e7
e9fb238ebefee7dfaffae3f17df6fdf4f3feb7fd3972f4b9fcfff5ef7f71beaef3f3635fffb3effff6f3f1bfcdcfe773f99ffdafcfef07bffe7ef4fafe67cd779fafebfcfc70aeffb3dfeffe9ffecff9f9fedfe6e73efff9ebfbc19f7dbedffa97fc11ffabf37ff6dfceb3bff9b53ffe7cfd6ffb739eff81bfde646fbecb9ffd
f1fba1fff8f9cc1ff1ff07ceb3bfd89b4c72bfb1fef0f3f9bfedcf7dfe07fe075ffed7fbea8fc6d9efbbfa9f9fcefa5ffd167f9d477ff44fbf9fafff6d7eeeff2ccfffc09f5fe57f15d757bf37def6f7b37fe4eae5f92ffe3a63ffe57cfcf55fce3acfa39f1fcfd8193923675cfd7e3efeb73df6fc0ffc9738befaf3ff4fc5cf
fdfd8da349dadfdbba7e8b5fff8af3acfbff103be37f741efde47f1efd29de9fe2fc29eefef0f3feb7398ee77fe0af5452fbe69f63de5ebf5fbdf5ff4f473a6bed7f12bfff97f371fe1139237f44cef87e8b5fcfa39ffe143f9c913392c819392389bbefcffddfe6d8f33ff43ffa0e7f1f97abd771f7f0248ed673c6fb571cbf
c50fe7e3af3372defdfcfd53fc73ecf91ff8e38bfc78fc1af9f2bf3efcfe7becb89cbd8ea775a492393ae7f9b3fe513ffd1139237f44cef8e1bf9ccf7f39e33cdbcf727acec819392367e48cbcb137b9bdc7f1fce78f1f7ff2f771397a1d4fe3971e7eff2bfef83fc4ce787e8bfd7e75ae33fd2c919f223fc5f753e4a7d8ff24
7e4a7cc7f9fce38f5ff3e38ffe3de6e8f53fe871357ee9e97f71be7eef5cff87fc8fd3d79bb8cfc819392367e48cfbff12fd5f4552df713e7ffbfdcbff3e3ffef0c51fbfc7d7f7381bbff5f0fc16ffa7df9ef6dc7fb1ff43fec7ed63893371267e48fc90d8cfb19f63c7f1e47ff6c3f3f9eddb8fdf577ffe1e4fbfe368fcdafc
decef157fc76e68ff89f9c576ffb2fbfe77fdcde9649e6caf4ff1acd6179fd78e47f701eeff3f9f53b7e7cbff9ab75f487e368fdd139ce3f5cfff5fc1ff571fe9eff717bf9ff83c7fb7cffebdfbefef87e87bf5a47bfe3e8fcd139cef7bf9e8fe7fc1ff675fd8fdbfc7efafb7ff1ab3f8fe7f91f7dfbf1fe4e7fb69e1ef6f7e1
af1efea7ff93387f8b9fceab9febf7fc8ff3ffc8fff8d4c4efff8bf85f1ecff33ffe7ef147ebd7bf0f7ff6f4db7f39eb38fb5fdc67f5ac9ef59c47bf73cef67f7cda4f9144feaff95fbcffd7fc2f0ec924f1e7cf711fcff33ffeeaf8ae5f235ffddefaed38fcd5c3cec939ffc7b37dcecbd9fe8f4f4dfc99fc144dfc0f8fe7f9
__sfx__
011100000000018000000001800000000180000000018000000001800000000180000000018000000001800000000180000000018000000000000000000000000000000000000000000000000000000000000000
011200000403004030040200402004010040000403504035040300402504030040250403004025040100000000000000000403500000040300402004020040350103001025010300102507030070250303003025
011200001c7171e7171f727237271c7271e7271f727237271f71723717287272b7271f72723727287272b7272071725717287272c7272072725727287272c727197271c7272072725727197271c7272072725727
011200002f5142f5122f5122f5122f5122f5122f5122f5152e5142e5122e5122e512305113051230512305152f5142f5122f5122f5122b5112b5122b5122b5153351433512335123351230511305123051230515
011200000403004030040200402004010040000403504035040300402504030040250403004025040100400001030010300102001020010100102001025010350103001025010300102508030080250103001025
01120000000300003000020000200001004000000350003500030000250003000025000300002500010040000303003030060200602009010090200c0250c0350f0300f025120301202515030150251803018025
01120000187171c7171f72724727187271c7271f727247271c7271e72724727287271c7271e72724727287272172723727277271e7272172724727277272a7271b727237272a7272d7271b727237272a7272d727
011200001c0301c0301c0301c0301c0221c0221c0221c0221c0301c0301e0301e0351f0301f030230302303525030250302503225032250222502200000200352503125030270302703028030280302a0312a030
011200002b0302b0302b0302b0302b0222b0222b0222b0222a0302a02500000280252a0301e0252b0302b02527031270302703027032270222702224030240252303123030230302303223022230222202223022
001200001c60004600000000000000000000001c60004600290001c600000000000000000000001c600046001c60004600000000000000000000001c60004600346001c600000000000000000000000000000000
3112000015030150251c0301c0251e0301e02521030210252403024025000000000000000000000000000000140301402517030170251c0301c02520030200252303023025000000000000000000000000000000
3112000028720287152a7202a7152d7202d7153072030715347203471500000000000000000000000000000028720287152a7202a7152c7202c7152f7202f7153472034715000000000000000000000000000000
31120000130301302518030180251c0301c0251e0301e0252403024025000000000000000000000000000000120301202517030170251b0301b0251e0301e0252303023025000000000000000000000000000000
0012000028720287152a7202a7152d7202d71530720307153472034715000000000000000000000000000000277202771528720287152a7202a7152f7202f7153372033715000000000000000000000000000000
3112000015030150251c0301c0251e0301e025210302102524030240252d0102d01530010300152d0102d015130301302517030170251c0301c0251f0301f02523030230252b0102b0152f0102f0152b0102b015
0112000028720287152a7202a7152d7202d7153072030715347203471500000000000000000000000000000028720287152a7202a7152b7202b7152f7202f7153472034715367003670037700377003470034700
31120000120301202519030190251c0301c0251e0301e02524030240252a0102a01530010300152a0102a0150f0300f025170301702515030150251f0301f0251e0301e025280202802527020270202302023020
01120000227202271528720287152a7202a7152e7202e7153472034715000000000000000000000000000000237202371527720277152a7202a7152d7202d71530720307152f7202f7202b7202b7202772027720
00120000306130c61300000000000000000000000000c614186100c613000000000000000000000000000000306130c61300000000000000000000000000c614186100c613000000000000000000000000000000
00120000306130c61300000000000000000000000000c614186100c61300000000003c613186150000000000306130c61300000000000000000000000000c614186100c613186100c6133c613186150000000000
01120000365103651036510365103651036510345113451036511365103751137510335113351034511345102f5112f5102f5102f5102f5102f5102e5112e5102f5112f51030511305102a5112a5102b5112b510
0112000025510255102551025510255102551023511235102451124510265112651028511285102b5112b5102a5112a5102a5102a5102a5102a51028511285102751127510275112751024511245102351123510
0112000004530000000b53000000105300c000135300c00012530000000b52000000105200c000135200c00012520000000b51000000105100c000135100c0001251000000000000000000000000000000000000
0112000000530000000b53000000105300c000135300c00012530000000b52000000105200c000135200c00012520000000b510000000f5100c000135100c0001251000000000000000000000000000000000000
3112000000000000000000000000210102101528010280152a0102a0152d0102d01530010300152d0102d015000000000000000000002001020015230102301528010280152c0102c0152f0102f0152c0102c015
19120000000000000000000000001f0101f015240102401528010280152a0102a01530010300152a0102a015000000000000000000001e0101e015230102301527010270152a0102a0152f0102f0152a0102a015
0012000000000000000000000000180001800018000000000c0000000000000000001700017000170000000000000000000c000000001e0001e0001e0001e0001f0001e0001c0001e0001f0001f0001f00000000
011200001c1001c1001c10000000281002810028100000001c1001c1001c100000002610026100261000000000000000001c10000000281002810028100281002610028100241002610021100231001c1001a100
0012000009000000000900000000180001800018000000001500000000090000000017000170001700000000000000000009000000001e0001e0001e0001e0001f0001e0001c0001e0001f0001f0001f00000000
0012000011000000000500000000180001800018000000001100000000050000000017000170001700000000000000000011000000001d0001d0001d0001d0001f0001d0001c0001d0001f0001f0001f00000000
011200001703017030170201702502020020010e0110e01515035150251703017030170251701515020150101703017030170201702501020020011003010030100201002010020100200f0300f0251003010025
011200001303013030130201302500020020010c0110c0151203512025130301303013025130151002010010120301203012020120250f0351002512020120111703017020180311803118021180121a0301a010
011200001703017030170201702502020020010e0110e01515035150251703017030170251701510020100101503015030150201502517020170251003010030100201002010010100100f0300f0251003010025
0112000015030150301502015025170201702518020180201802018020180251a0151a0201a0101a0301a0301b0201b0251b0201b0221c0111c0111c0301c0201c0211e0211e0211e01123027240172303724027
001200002460000000000000000000000000000c6001860024600000000000000000000000000000000000002460000000000000000000000000000c60018600246000000000000000003e600000000000000000
0012000026700267002670026700267002670026700267002670026700267000e70023700237002370023700237002370023700217001f7001f7001f700137002b7002b7002b7002a7002870028700287000e700
0112000023022230222302215001230002300023000230000000000000000001f0001f0001f0001f0001f0001f0001f0001f0001c0001c0001c0001c000230002300023000230001f0001f0001f0001f00000000
01120000025502870007550287000b5501c70010550287000e5502a7000b5402b7000e5302a7000b5202d0000155030700075502f7000b5502f7000d5502b70010550287000d540287000a530000000752000000
011200001a7171f71723717287271a7271f72723727287171a7171f727237272a72723727287272b7172f717197171f7172372728727197271f7272272728717197171f727227272a727197271f727237172b717
01120000187171f7172372728727187271f7272372728717187171f727237272a72718727287272b7172f7171b7171e71723727277271b7271e72723727277171b7171e727237272a727277272a7272f71733717
01120000187171d7172172728727187271d7272372728717187171d727217272b7271d727217272471728717337172f7172a72727727237271e7271b72718717217171e7271b72724727217271e7272771724717
9112000000500005002651026510335113351033510335103251132510325103251032512325123251232512005000050000500000002e5102e5102e5102e5102f5112f5102f5102f5102f5122f5122f5122f512
911200000000000000000000000029510295102951229512355113551235512355123451134510345123451233511335103351033510335123351233512335123b5113b5103b5103b5103b5123b5123b5123b512
011200000055000000075500050004550000000b5500000006550000000055000000045500000000550000000305000000060500000003050000000b050000000605000000030500000006050000000305000000
0112000000550000000555000500095500c5000c5500c500105500c500115500c500105500c5000c5500050003550005000655000500095500c5000f55000500095500c5000f5500050009550005000655000000
001000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000
001000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000
001000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000
001000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000
001000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000
0134000000000220352203525035250202502500000000000000022035220352703527035000002202020035000002203522035250352502025025000000000000000220352203527035270352a0352a0352e035
01340000000002203522035270352703500000220350000000000200352003523035230350000025035220350000022035220352503525035000000000000000000002203522035260352603529035290352c035
013400002e0202e0252a035270352702027025220350000000000200352003523035230350000025020220350000022035220352503525020250250000000000000002203522035260352602029035290352c035
001000002150000000285000000024500000002350000000285000000024500000002150000000285000000024500000001f50000000285000000024500000002150000000285000000024500000000000000000
001600000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000
613400003102031020310252e02531020310202e02500000300002e025310203102533020330252e0252c0252e0202e0202e0252a0252e0202e0202902500000000002a0252a0202e02530020330253502536025
6134000036020360203602533025360203602033025000000000033025330202f02533020310252c025310252e0202e0202e0202e0202e0202e0250000000000300002a0252a0202e0252f020320252c0252f025
001000000210002100021000210002000020000210002100021000210002000090000e100021000210002100020000200005100051001310011100100000c0000000000000000000000000000000000000000000
493400000b0351b0351b0201e0351e0351230012500120000803517035170201b0351b0201b0250b035000000603519035190201e0351e0351230012500120001203519035190201703500000170351a03500000
493400001203519035190201e0351e035123001250012000120351b0351b0201e0351e0301b0351b025000001203519035190201e0351e0351230012500120000c02018035180201e0351e035220352203500000
001000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000
001000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000
00100000117002470028700000001d70021700267000c700117002170024700000001d7001f7002870017700187002470028700000001870023700287001370018700217002870000000187001f7002170026700
001000000c700247002870000000187002370028700000000c700217002870000000187001f7001a7001c7000c700247002870000000187002370028700000000c7002170028700000001c7001e7002170024700
__music__
00 01424344
00 01420344
00 04024344
00 05064344
01 04020716
00 05060817
00 04020716
00 05060817
00 0a180b12
00 0c190d12
00 0e140f13
00 10151113
00 04020716
00 05060817
00 04020716
00 05060817
00 1e262425
00 1f27002b
00 20262925
02 21282a2c
00 40404040
00 40404040
00 41424344
00 41424344
00 41424344
00 41424344
00 41424344
00 41424344
00 41424344
00 41424344
00 41424344
00 41424344
00 3b320000
00 3a340000
01 3b323700
02 3a333800
00 3b343744
04 3a353844
00 7e737844
00 7e747944

